structure BlocksWorld = struct
  open Logic
  
  (* Variables need to be quantified, blocks are hard coded *)
  datatype block
    (* Assume an implicit forall x y z : block *)
    (* aliased to x,y,z *)
    = VarX | VarY | VarZ
    (* Hardcoded blocks from the handout by name *)
    (* aliased to a,b,c,d,e,f *)
    | BlockA | BlockB | BlockC | BlockD | BlockE | BlockF
  
  
  datatype atom
    = AEmpty
    | AHolds of block
    | AClear of block
    | AOn of block * block
    | AOnTable of block
    | ASpace

  datatype prop
    = PAtom of atom
    | PTensor of prop * prop
    | POne
    | PPlus of prop * prop
    | PZero
    | PWith of prop * prop
    | PTop
    | PLolli of prop * prop
    | PBang of prop

  (* Variable shortcuts *)
  val (x,y,z) = (VarX, VarY, VarZ)

  (* Block shortcuts *)
  val (a,b,c,d,e,f) = (BlockA,BlockB,BlockC,BlockD,BlockE,BlockF)

  (* Atom shortcuts *)
  val (empty,holds,clear,on,on_table,space) = (PAtom AEmpty,PAtom o AHolds,PAtom o AClear,PAtom o AOn,PAtom o AOnTable,PAtom ASpace)

  (*
   * Connective shortcuts in order of precedence
   * O for one
   * Z for zero
   * T for top
   * ! for bang
   * * for tensor
   * & for with
   * + for plus
   * -@ for lolli
   *)
  val (op*,op+,&,-@,!,O,Z,T) = (PTensor,PPlus,PWith,PLolli,PBang,POne,PZero,PTop)

end
