structure LLExamples = struct
  open LinearLogic 
  
  infixr 9 *
  infixr 8 &
  infixr 7 +
  infixr 6 -@

  infix 5 ||-

  infix 4 seq

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val lolli_refl : proof =
    []
    ---------- Init
    seq [A] ||- A
    +--------- LolliR
    seq [] ||- A -@ A
  
  val tensor_comm : proof = 
    [
      []
      ----- Init
      seq [B] ||- B
    ,
      []
      ----- Init
      seq [A] ||- A
    ]
    ----- TensorR
    seq [A, B] ||- B * A
    +---- TensorL
    seq [A * B] ||- B * A
    +---- LolliR
    seq [] ||- A * B -@ B * A
  
  val with_comm : proof = 
    [
      []
      ----- Init
      seq [B] ||- B
      +---- WithL2
      seq [A & B] ||- B
    ,
      []
      ----- Init
      seq [A] ||- A
      +---- WithL1
      seq [A & B] ||- A
    ]
    ----- WithR
    seq [A & B] ||- B & A
    +---- LolliR
    seq [] ||- A & B -@ B & A
end