structure HAExamples = struct
  open HeytingArithmetic 
  
  infixr 8 ^
  infixr 7 v
  infixr 6 >

  infix 9 eq

  infix 5 :::

  infix 4 tru nat obj

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val tau_exists : proof =
    [
      [
        []
        ------- Hyp "u"
        tru (exi "x" tau (Aof (var "x")))
      ,
        [
          []
          ------- Hyp "a"
          obj var "a" ::: tau
        ,
          []
          ----- Hyp "v"
          tru (Aof (var "a"))
        ]
        -------- ExistsI
        tru (exists "y" tau (Aof (var "y")))
      ]
      ----- ExistsE ("a","v")
      tru exi "y" tau (Aof (var "y"))
    ]
    ----- ImpI "u"
    tru (exists "x" tau (Aof (var "x"))) > (exists "y" tau (Aof (var "y")))
  
  val zero_refl : proof = 
  []
  ------ EqualsI00
  tru Z eq Z

  val two_is_nat : proof =
  [
    [
      []
      ----- NatI0
      nat Z
    ]
    ------ NatIs
    obj S(Z) ::: Nat
  ]
  ----- NatIs
  nat S(S(Z))

  val proof_of_refl : proof =
    [
      [
          []
          ------- Hyp "a"
          nat (var "a")
      ,
          []
          ------- EqualsI00
          tru (Z eq Z)
      ,
          [
              []
              ------- Hyp "p"
              tru ((var "b") eq (var "b"))
          ]
          ---------- EqualsIss
          tru ((S(var "b")) eq (S(var "b")))
      ]
      --------- NatE ("b","p")
      tru ((var "a") eq (var "a"))
  ]
  ---------- ForallI "a"
  tru for "x" Nat ((var "x") eq (var "x"))

  (* In this proof we have access to the reflexivity theorem "Refl" proved right above *)
  val forall_exists_succ : proof_refl_admissible =
  [
    [
      [
        []
        ------ Hyp "a"
        nat var "a"
      ]
      ------ NatIs
      nat S(var "a")
    ,
      [
        [
          []
          ------ Hyp "a"
          nat var "a"
        ]
        ------ NatIs
        nat S(var "a")
      ]
      ====== Refl (* We use === to distringuish that Refl is a theorem not a real heyting arithmetic rule *)
      tru S(var "a") eq S(var "a")
    ]
    ------ ExistsI
    tru exi "y" Nat (S(var "a") eq (var "y"))
  ]
  ------ ForallI "a"
  tru forall "x" Nat (exists "y" Nat ((S(var "x")) eq (var "y")))

end