structure VerificationsAndUses = struct
  open Logic
  
  datatype prop = datatype NaturalDeduction.prop

  (* There are two judgments: verifications and uses *)
  datatype judgment
    = JUp of prop
    | JDown of prop
    
  datatype rule
    = Hyp of hypothesis
    | TrueI
    | FalseE
    | AndI | AndE1 | AndE2
    | OrI1 | OrI2 | OrE of hypothesis * hypothesis
    | ImpI of hypothesis | ImpE
    | DownUp
  
  type given = void
  type theorem = void
  type proof = (given, theorem, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree
  
  (* 
   * Macros for writing propositions
   * These will be infixed for you in a HW's starter code if it uses natural deduction 
   *)

  (* Atom proposition shortcuts *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)
  
  (*
   * Connective shortcuts in order of precedence
   * T for truth
   * F for false
   * ~ for negation (aka implying false)
   * ^ for and
   * v for or
   * > for implies
   *)
  val (op^,v, op>, ~, T, F) = (PAnd,POr,PImp,fn a => PImp(a,PFalse), PTrue, PFalse)

  (* 
   * Truth judgment magic to use with -- and ==
   * Example Usage:
     
     [proof_of_A_up,proof_of_B_up]
     --------- AndI
     up A ^ B
     
   *)
  fun up (f,p) = (f,JUp p)
  fun down (f,p) = (f,JDown p)
  fun given_up_hyps   hyps name prop = Given ((hyps,name),JUp   prop)
  fun given_down_hyps hyps name prop = Given ((hyps,name),JDown prop)
  fun given_up   name prop = given_up_hyps   [] name prop
  fun given_down name prop = given_down_hyps [] name prop
end