(* Propositional formulas *)
signature PROP =
sig
  datatype prop =                 (* A ::=            *)
      Atom of string              (*       P          *)
    | True                        (*     | T          *)
    | And of prop * prop          (*     | A1 & A2    *)
    | False                       (*     | F          *)
    | Or of prop * prop           (*     | A1 | A2    *)
    | Imp of prop * prop          (*     | A1 => A2   *)

  val Not : prop -> prop          (* ~A := A => F     *)
  
  val toString : prop -> string
  val toStringList : prop list -> string
  val eq : prop * prop -> bool
end
