structure Test :> TEST =
struct
  structure G = G4ip
  structure P = Prop

  val ==> = P.Imp
  val & = P.And
  val v = P.Or
  val f = P.False
  val t = P.True
  val ~ = P.Not
  val <=> = fn (A,B) => P.And (P.Imp (A, B), P.Imp (B, A))
  val <== = fn (A,B) => P.Imp (B, A)

  infix 9 &
  infix 8 v
  infixr 7 ==>
  infix 7 <==
  infix 6 <=>
  val A = P.Atom "A"
  val B = P.Atom "B"
  val C = P.Atom "C"
  val D = P.Atom "D"
  val E = P.Atom "E"
  val F = P.Atom "F"
  val G = P.Atom "G"
  val H = P.Atom "H"
  val R = P.Atom "R"
  val S = P.Atom "S"

  val errors = ref 0

  fun check (D, A) expected =
    let val expected_str = (if not expected then " un" else " ") ^ "provable"
    in print ("Checking " ^ P.toStringList D ^ " --R--> " ^ P.toString A ^ expected_str ^ "... ");
       if G.decide D A = expected
         then print "\027[1;30m[\027[32m OK! \027[30m]\027[m\n"
         else (print "\027[1;30m[\027[31m WRONG \027[30m]\027[m\n";
               errors := !errors + 1)
    end

  fun cfalse (D, A) = check (D, A) false
  fun ctrue (D, A) = check (D, A) true

  (* tests : (P.prop list * P.prop * bool) list
     A list of sequents along with their expected truth values *)
  val tests : (P.prop list * P.prop * bool) list =
    [
      ([], A, false),
      ([], t, true),
      ([f], A, true),
      ([A,B], A & B, true),
      ([A], A v B, true),
      ([B], A v B, true),
      ([t], f, false),
      ([A, B v C], A & B, false),
      ([A v B], A v B, true),
      ([A v B], A & B, false),
      ([A v B v C], A v B v C, true),
      ([(A v B) & C], (A v C) & (B v C), true),
      ([], A ==> A , true ),
      ([], A ==> (B ==> A) , true ),
      ([], (A ==> B) ==> (A ==> (B ==> C)) ==> (A ==> C) , true )
    ]

  fun runtests () =
    (errors := 0;
     List.app (fn (cx, a, e) => check (cx, a) e) tests;
     if !errors = 0
       then print "*** All tests passed!\n"
       else print ("!!! " ^ Int.toString (!errors) ^ " test(s) failed.\n"))

end (* structure Test *)
