signature TEST =
sig
  (* check A b: check that the prover determines A to have truth value b,
     printing a useful message on standard output.
   *)
  val check : Prop.prop list * Prop.prop -> bool -> unit

  (* the above specialized to true and false *)
  val ctrue : Prop.prop list * Prop.prop -> unit
  val cfalse : Prop.prop list * Prop.prop -> unit

  (* a list of propositions along with their expected truth values *)
  val tests : (Prop.prop list * Prop.prop * bool) list

  (* runtests (): runs all the tests in [tests], keeping an error count.
     prints status messages to standard output.
   *)
  val runtests : unit -> unit
end (* signature TEST *)
