(* Propositional formulas *)
structure Prop :> PROP =
struct
  datatype prop =                 (* A ::=            *)
      Atom of string              (*       P          *)
    | True                        (*     | T          *)
    | And of prop * prop          (*     | A1 & A2    *)
    | False                       (*     | F          *)
    | Or of prop * prop           (*     | A1 | A2    *)

  fun showParen true  s = "(" ^ s ^ ")"
    | showParen false s = s

  (* operator precendences *)
  val and_prec = 9
  val or_prec  = 8

  (* print formulas with as few parentheses as possible *)
  fun toStringPrec p (And (A, B)) =
      showParen (p > and_prec)
                (toStringPrec (and_prec + 1) A ^ " & "  ^ toStringPrec and_prec B)
    | toStringPrec p (Or (A, B)) =
      showParen (p > or_prec)
                (toStringPrec (or_prec + 1) A  ^ " | "  ^ toStringPrec or_prec B)
    | toStringPrec _ (Atom s) = s
    | toStringPrec _ True     = "T"
    | toStringPrec _ False    = "F"

  fun toString x = toStringPrec 0 x

  fun toStringList [] = "."
    | toStringList [p] = toString p
    | toStringList (p::ps) = toString p ^ ", " ^ toStringList ps

  val eq = op=
end
