test_not_member(_, []).
test_not_member(X, [Y|L]) :- X \= Y, test_not_member(X, L).

test_valid_color(_, _, [], _).
test_valid_color(X, C, [edge(X,Y)|E], Painted) :-
  test_not_member((Y, C), Painted), test_valid_color(X, C, E, Painted).
test_valid_color(X, C, [edge(Y,X)|E], Painted) :-
  test_not_member((Y, C), Painted), test_valid_color(X, C, E, Painted).
test_valid_color(X, C, [edge(A,B)|E], Painted) :-
  X \= A, X \= B, test_valid_color(X, C, E, Painted).

test_valid_coloring(_, _, _, []).
test_valid_coloring(N, E, Ok, [(X,C)|T]) :-
  color(C),
  member(node(X), N),
  append(Ok, T, All),
  test_valid_color(X, C, E, All),
  test_valid_coloring(N, E, [(X,C)|Ok], T).

test_all_valid(_, _, []).
test_all_valid(N, E, [C|Clrs]) :- test_valid_coloring(N, E, [], C), test_all_valid(N, E, Clrs).

test(1) :-
  N = [node(a),node(b),node(c)],
  E = [edge(a,b),edge(b,c),edge(a,c)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 24,
  test_all_valid(N, E, Clrs).

test(2) :-
  N = [node(a),node(b),node(c),node(d)],
  E = [edge(a,b),edge(b,c),edge(c,d),edge(d,a)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 84,
  test_all_valid(N, E, Clrs).

test(3) :-
  N = [node(a),node(b),node(c),node(d)],
  E = [edge(a,b),edge(b,c),edge(c,d),edge(d,a),edge(a,c),edge(d,b)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 24,
  test_all_valid(N, E, Clrs).

test(4) :-
  N = [node(a)],
  E = [],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 4,
  test_all_valid(N, E, Clrs).

test(5) :-
  N = [node(a),node(b)],
  E = [edge(a,b)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 12,
  test_all_valid(N, E, Clrs).

test(6) :-
  N = [node(a),node(b)],
  E = [],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 16,
  test_all_valid(N, E, Clrs).

test(7) :-
  N = [node(a),node(b),node(c),node(d),node(e),node(f),node(g),node(h)],
  E = [edge(a,e),edge(b,f),edge(c,g),edge(d,h)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 20736.
%   test_all_valid(N, E, Clrs). Stack overflow if the solution is checked :(

test(8) :-
  N = [node(a),node(b),node(c),node(d),node(e),node(f),node(g),node(h)],
  E = [edge(a,e),edge(b,f),edge(c,g),edge(d,h),edge(a,b),edge(b,c),edge(c,d),edge(e,f),edge(f,g),edge(g,h),edge(a,f),edge(f,c),edge(c,h)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 768,
  test_all_valid(N, E, Clrs).

test(9) :-
  N = [node(a),node(b),node(c),node(d),node(e)],
  E = [edge(a,b),edge(b,c),edge(c,d),edge(d,e),edge(e,a),edge(c,e),edge(c,a)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 96,
  test_all_valid(N, E, Clrs).

test(10) :-
  N = [node(wa),node(nt),node(sa),node(ql),node(nsw),node(vc),node(tas)],
  E = [edge(wa,nt),edge(wa,sa),edge(nt,sa),edge(nt,ql),edge(sa,ql),edge(sa,nsw),edge(sa,vc),edge(ql,nsw),edge(nsw,vc)],
  setof(C, color_graph(N, E, C), Clrs),
  length(Clrs, L), L = 768,
  test_all_valid(N, E, Clrs).


result :- (setof(X, test(X), Ok) -> true ; Ok = []), length(Ok, N),
	  format(user_output, "You passed ~p of 10 tests.\n", [N]),
	  halt.
