/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include "mmgr.h"

#include "Vector2.h"

/*******************************/

const Vector2 Vector2::ZERO   = Vector2 (0, 0);
const Vector2 Vector2::UNIT_X = Vector2 (1, 0);
const Vector2 Vector2::UNIT_Y = Vector2 (0, 1);

/*******************************/

Vector2::Vector2 ()
{
	this->x = 0;
	this->y = 0;
}

/*******************************/

Vector2::Vector2 (Real x, Real y)
{
	this->x = x;
	this->y = y;
}

/*******************************/

Vector2::Vector2 (const Vector2& vector)
{
	x = vector.x;
	y = vector.y;
}

/*******************************/

Vector2::~Vector2 ()
{
}

/*******************************/

Real& Vector2::operator [] (const unsigned int i) const
{
	return ((Real*)this)[i];
}

/*******************************/

Vector2::operator Real* ()
{
	return (Real*)this;
}

/*******************************/

void Vector2::operator = (const Vector2& vector)
{
	x = vector.x;
	y = vector.y;
}

/*******************************/

void Vector2::operator += (const Real scalar)
{
	x += scalar;
	y += scalar;
}

/*******************************/

void Vector2::operator += (const Vector2& vector)
{
	x += vector.x;
	y += vector.y;
}

/*******************************/

void Vector2::operator -= (const Real scalar)
{
	x -= scalar;
	y -= scalar;
}

/*******************************/

void Vector2::operator -= (const Vector2& vector)
{
	x -= vector.x;
	y -= vector.y;
}

/*******************************/

void Vector2::operator *= (const Real scalar)
{
	x *= scalar;
	y *= scalar;
}

/*******************************/

Vector2 Vector2::operator + (const Real scalar) const
{
	return Vector2 (x + scalar, y + scalar);
}

/*******************************/

Vector2 Vector2::operator + (const Vector2& vector) const
{
	return Vector2 (x + vector.x, y + vector.y);
}

/*******************************/

Vector2 Vector2::operator - (const Real scalar) const
{
	return Vector2 (x - scalar, y - scalar);
}

/*******************************/

Vector2 Vector2::operator - (const Vector2& vector) const
{
	return Vector2 (x - vector.x, y - vector.y);
}

/*******************************/

Vector2 Vector2::operator * (const Real scalar) const
{
	return Vector2 (x * scalar, y * scalar);
}

/*******************************/

Vector2 Vector2::operator / (const Real scalar) const
{
	return Vector2 (x / scalar, y / scalar);
}

/*******************************/

Vector2 operator + (const Real scalar, const Vector2& vector)
{
	return vector + scalar;
}

/*******************************/

Vector2 operator - (const Real scalar, const Vector2& vector)
{
	return vector - scalar;
}

/*******************************/

Vector2 operator * (const Real scalar, const Vector2& vector)
{
	return vector * scalar;
}

/*******************************/

Real Vector2::dot (const Vector2& vector) const
{
	return x * vector.x + y * vector.y;
}

/*******************************/

Real Vector2::lengthSquared ()
{
	return dot (*this);
}

/*******************************/

Real Vector2::length ()
{
	return Math::sqrt (lengthSquared ());
}

/*******************************/

Vector2 Vector2::unit ()
{
	return *this / length ();
}

/*******************************/
