/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include <ode/ode.h>

#include "mmgr.h"

#include "Simulator.h"
#include "SliderJoint.h"
#include "RigidBody.h"

SliderJoint::SliderJoint (RigidBody* rigidBody1, RigidBody* rigidBody2) : Joint (rigidBody1, rigidBody2)
{
	joint = dJointCreateSlider (Simulator::getInstance ()->getWorld (), 0);
	
	dJointAttach (joint, rigidBody1->getBody (), rigidBody2->getBody ());
}

SliderJoint::~SliderJoint ()
{
}

void SliderJoint::set (char* name, char* value)
{
}

void SliderJoint::setAxis (const Vector3& axis)
{
	dJointSetSliderAxis (joint, axis.x, axis.y, axis.z);
}

void SliderJoint::setLimits (const Real lowLimit, const Real highLimit)
{
	dJointSetSliderParam (joint, dParamLoStop, lowLimit);
	dJointSetSliderParam (joint, dParamHiStop, highLimit);
}

void SliderJoint::setMaxForce (const Real maxForce)
{	
	dJointSetSliderParam (joint, dParamFMax, maxForce);
}

void SliderJoint::setTargetVelocity (const Real velocity)
{
	dJointSetSliderParam (joint, dParamVel, velocity);
}
