/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include "mmgr.h"

#include "Event.h"
#include "RigidBody.h"
#include "RigidBodyEntity.h"
#include "Spatial.h"

/*******************************/

RigidBodyEntity::~RigidBodyEntity ()
{
}

/*******************************/

void RigidBodyEntity::handleEvent (Event* event)
{
	if (!event)
	{
		return;
	}

	PositionEvent* positionEvent = dynamic_cast<PositionEvent *> (event);

	if (positionEvent)
	{
		rigidBody->setWorldPosition (positionEvent->position);
		model->updateWorldData (0.0);

		delete event;
		return;
	}

	RotationEvent* rotationEvent = dynamic_cast<RotationEvent *> (event);

	if (rotationEvent)
	{
		rigidBody->setWorldRotation (rotationEvent->rotation);
		model->updateWorldData (0.0);

		delete event;
		return;
	}


	Entity::handleEvent (event);
}

/*******************************/

RigidBodyEntity::RigidBodyEntity ()
{
	rigidBody = 0;
}

/*******************************/
