/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "mmgr.h"

#include "Math.h"

const Real Math::INF        = HUGE_VAL;
const Real Math::PI         = M_PI;
const Real Math::TWO_PI     = M_PI  * 2.0;
const Real Math::HALF_PI    = M_PI  / 2.0;
const Real Math::FOURTH_PI  = M_PI  / 4.0;
const Real Math::RAD_TO_DEG = 180.0 / M_PI;
const Real Math::DEG_TO_RAD = M_PI  / 180.0;

Real Math::abs (Real r)
{
	if (r < 0.0)
	{
		return -r;
	}

	return r;
}

Real Math::sign (Real r)
{
	if (0.0 < r)
	{
		return 1.0;
	}

	if (r < 0.0)
	{
		return -1.0;
	}

	return 0.0;
}

Real Math::sqrt (Real r)
{
	return ::sqrt (r);
}

Real Math::min (Real r1, Real r2)
{
	return r1 < r2 ? r1 : r2;
}

Real Math::max (Real r1, Real r2)
{
	return r1 > r2 ? r1 : r2;
}

Real Math::sin (Real a)
{
	return ::sin (a);
}

Real Math::cos (Real a)
{
	return ::cos (a);
}

Real Math::tan (Real a)
{
	return ::tan (a);
}

Real Math::asin (Real r)
{
	return ::asin (r);
}

Real Math::acos (Real r)
{
	return ::acos (r);
}

Real Math::atan (Real r)
{
	return ::atan (r);
}

Real Math::atan2 (Real y, Real x)
{
	return ::atan2 (y, x);
}

Real Math::random ()
{
	return (Real) rand () / ((Real) RAND_MAX + 1.0);
}

Real Math::random (Real min, Real max)
{
	return (max - min) * ((Real) rand ()) / (RAND_MAX + 1.0) + min;
}
