/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include <ode/ode.h>

#include "mmgr.h"

#include "Simulator.h"
#include "Hinge2Joint.h"
#include "RigidBody.h"

Hinge2Joint::Hinge2Joint (RigidBody* rigidBody1, RigidBody* rigidBody2) : Joint (rigidBody1, rigidBody2)
{
	joint = dJointCreateHinge2 (Simulator::getInstance ()->getWorld (), 0);
	
	dJointAttach (joint, rigidBody1->getBody (), rigidBody2->getBody ());

	dJointSetHinge2Param (joint, dParamLoStop,  0.0);
	dJointSetHinge2Param (joint, dParamHiStop,  0.0);
	dJointSetHinge2Param (joint, dParamVel,     0.0);
	//dJointSetHinge2Param (joint, dParamStopCFM, 0.5);
	//dJointSetHinge2Param (joint, dParamStopERP, 0.9);
	dJointSetHinge2Param (joint, dParamFMax,    dInfinity);
	dJointSetHinge2Param (joint, dParamFMax2,   dInfinity);
}

Hinge2Joint::~Hinge2Joint ()
{
}

void Hinge2Joint::set (char* name, char* value)
{
}

void Hinge2Joint::setAnchor (const Vector3& anchor)
{
	dJointSetHinge2Anchor (joint, anchor.x, anchor.y, anchor.z);
}

void Hinge2Joint::setAxis1 (const Vector3& axis1)
{
	dJointSetHinge2Axis1 (joint, axis1.x, axis1.y, axis1.z);
}

void Hinge2Joint::setAxis2 (const Vector3& axis2)
{
	dJointSetHinge2Axis2 (joint, axis2.x, axis2.y, axis2.z);
}

void Hinge2Joint::setMaxForce1 (const Real maxForce1)
{	
	dJointSetHinge2Param (joint, dParamFMax, maxForce1);
}

void Hinge2Joint::setMaxForce2 (const Real maxForce2)
{	
	dJointSetHinge2Param (joint, dParamFMax2, maxForce2);
}

void Hinge2Joint::setTargetVelocity (const Real velocity)
{
	dJointSetHinge2Param (joint, dParamVel2, velocity);
}
