/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include <typeinfo>

#include "mmgr.h"

#include "CollisionController.h"
#include "CollisionManager.h"
#include "Geometry.h"
#include "Node.h"

/*******************************/

Geometry::Geometry (char* name) : Spatial (name)
{
	geometry            = 0;
	color               = Vector3 (1.0, 1.0, 1.0);
	collisionController = 0;
}

/*******************************/

Geometry::~Geometry ()
{
	dGeomDestroy (geometry);

	delete collisionController;
}

/*******************************/

CollisionController* Geometry::getCollisionController ()
{
	return collisionController;
}

/*******************************/

dGeomID& Geometry::getGeometry ()
{
	return geometry;
}

/*******************************/

BoundingSphere& Geometry::getModelBound ()
{
	return modelBound;
}

/*******************************/

void Geometry::setCollisionController (CollisionController* collisionController)
{
	this->collisionController = collisionController;
}

/*******************************/

void Geometry::setGeometry (const dGeomID& geometry)
{
	this->geometry = geometry;
}

/*******************************/

void Geometry::setModelBound (const BoundingSphere& modelBound)
{
	this->modelBound = modelBound;
}

/*******************************/

void Geometry::setColor (const Vector3& color)
{
	this->color = color;
}

/*******************************/

void Geometry::updateWorldData (Real deltaTime)
{	
	Spatial::updateWorldData (deltaTime);

	if (geometry && dGeomGetClass (geometry) != dPlaneClass)
	{
		dGeomSetPosition (geometry, worldPosition.x, worldPosition.y, worldPosition.z);
		
		dMatrix3 r;
		r[0]  = worldRotation[0][0];
		r[1]  = worldRotation[0][1];
		r[2]  = worldRotation[0][2];
		r[3]  = 0.0;
		r[4]  = worldRotation[1][0];
		r[5]  = worldRotation[1][1];
		r[6]  = worldRotation[1][2];
		r[7]  = 0.0;
		r[8]  = worldRotation[2][0];
		r[9]  = worldRotation[2][1];
		r[10] = worldRotation[2][2];
		r[11]  = 0.0;

		dGeomSetRotation (geometry, r);
	}
}

/*******************************/

void Geometry::updateWorldBound ()
{
	worldBound = modelBound.transformBy (worldScale, worldRotation, worldPosition);
}

/*******************************/

void Geometry::draw ()
{
}

/*******************************/

void Geometry::collidingWith (Spatial* object)
{
	CollisionManager* collisionManager = CollisionManager::getInstance ();

	collisionManager->addCollision (this, object);
}

/*******************************/
