/*=========================================================================
<<<<<<< Field.cc
	UberSim Source Code Release
	-------------------------------------------------------------------------
	Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
	James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
	Erick Tryzelaar {erickt}@andrew.cmu.edu
	School of Computer Science, Carnegie Mellon University
	-------------------------------------------------------------------------
	This software is distributed under the GNU General Public License,
	version 2.  If you do not have a copy of this licence, visit
	www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
	Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
	in the hope that it will be useful, but WITHOUT ANY WARRANTY,
	including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	-------------------------------------------------------------------------*/

#ifdef USE_OPENGL
#include <drawstuff/drawstuff.h>
#endif

#include "../utils/configreader.h"

#include "mmgr.h"

#include "BoxGeometry.h"
#include "Field.h"
#include "Geometry.h"
#include "PlaneGeometry.h"

CR_DECLARE (LONG_LENGTH);
CR_DECLARE (LONG_WIDTH);
CR_DECLARE (LONG_HEIGHT);
CR_DECLARE (TOP_LONG_POSITION);
CR_DECLARE (BOTTOM_LONG_POSITION);
CR_DECLARE (SHORT_LENGTH);
CR_DECLARE (SHORT_WIDTH);
CR_DECLARE (SHORT_HEIGHT);
CR_DECLARE (TOP_SHORT_POSITION);
CR_DECLARE (BOTTOM_SHORT_POSITION);
CR_DECLARE (GOAL_SIDE_LENGTH);
CR_DECLARE (GOAL_SIDE_WIDTH);
CR_DECLARE (GOAL_SIDE_HEIGHT);
CR_DECLARE (TOP_GOAL_SIDE_POSITION);
CR_DECLARE (BOTTOM_GOAL_SIDE_POSITION);
CR_DECLARE (GOAL_BACK_LENGTH);
CR_DECLARE (GOAL_BACK_WIDTH);
CR_DECLARE (GOAL_BACK_HEIGHT);
CR_DECLARE (GOAL_BACK_POSITION);

Field::Field (char* name) : Node (name)
{
	static bool isConfiged = false;

	if (!isConfiged)
	{
		isConfiged = true;

		CR_SETUP (Field, LONG_LENGTH, CR_DOUBLE);
		CR_SETUP (Field, LONG_WIDTH, CR_DOUBLE);
		CR_SETUP (Field, LONG_HEIGHT, CR_DOUBLE);
		CR_SETUP (Field, TOP_LONG_POSITION, CR_DOUBLE);
		CR_SETUP (Field, BOTTOM_LONG_POSITION, CR_DOUBLE);
		CR_SETUP (Field, SHORT_LENGTH, CR_DOUBLE);
		CR_SETUP (Field, SHORT_WIDTH, CR_DOUBLE);
		CR_SETUP (Field, SHORT_HEIGHT, CR_DOUBLE);
		CR_SETUP (Field, TOP_SHORT_POSITION, CR_DOUBLE);
		CR_SETUP (Field, BOTTOM_SHORT_POSITION, CR_DOUBLE);
		CR_SETUP (Field, GOAL_SIDE_LENGTH, CR_DOUBLE);
		CR_SETUP (Field, GOAL_SIDE_WIDTH, CR_DOUBLE);
		CR_SETUP (Field, GOAL_SIDE_HEIGHT, CR_DOUBLE);
		CR_SETUP (Field, TOP_GOAL_SIDE_POSITION, CR_DOUBLE);
		CR_SETUP (Field, BOTTOM_GOAL_SIDE_POSITION, CR_DOUBLE);
		CR_SETUP (Field, GOAL_BACK_LENGTH, CR_DOUBLE);
		CR_SETUP (Field, GOAL_BACK_WIDTH, CR_DOUBLE);
		CR_SETUP (Field, GOAL_BACK_HEIGHT, CR_DOUBLE);
		CR_SETUP (Field, GOAL_BACK_POSITION, CR_DOUBLE);
	}

	PlaneGeometry* plane = new PlaneGeometry (Vector3::UNIT_Z, 0, "Ground");	
	addChild (plane);

	Geometry* topLong    = new BoxGeometry (DVAR (LONG_LENGTH), DVAR (LONG_WIDTH), DVAR (LONG_HEIGHT), "Top Long");
	Geometry* bottomLong = new BoxGeometry (DVAR (LONG_LENGTH), DVAR (LONG_WIDTH), DVAR (LONG_HEIGHT), "Bottom Long");

	Geometry* leftTopShort    = new BoxGeometry (DVAR (SHORT_LENGTH), DVAR (SHORT_WIDTH), DVAR (SHORT_HEIGHT), "Left Top Short");
	Geometry* leftBottomShort = new BoxGeometry (DVAR (SHORT_LENGTH), DVAR (SHORT_WIDTH), DVAR (SHORT_HEIGHT), "Left Bottom Short");
	
	Geometry* rightTopShort    = new BoxGeometry (DVAR (SHORT_LENGTH), DVAR (SHORT_WIDTH), DVAR (SHORT_HEIGHT), "Right Top Short");
	Geometry* rightBottomShort = new BoxGeometry (DVAR (SHORT_LENGTH), DVAR (SHORT_WIDTH), DVAR (SHORT_HEIGHT), "Right Bottom Short");

	Geometry* leftTopGoalSide    = new BoxGeometry (DVAR (GOAL_SIDE_LENGTH), DVAR (GOAL_SIDE_WIDTH), DVAR (GOAL_SIDE_HEIGHT), "Left Top Goal Side");
	Geometry* leftBottomGoalSide = new BoxGeometry (DVAR (GOAL_SIDE_LENGTH), DVAR (GOAL_SIDE_WIDTH), DVAR (GOAL_SIDE_HEIGHT), "Left Bottom Goal Side");

	Geometry* rightTopGoalSide    = new BoxGeometry (DVAR (GOAL_SIDE_LENGTH), DVAR (GOAL_SIDE_WIDTH), DVAR (GOAL_SIDE_HEIGHT), "Right Top Goal Side");
	Geometry* rightBottomGoalSide = new BoxGeometry (DVAR (GOAL_SIDE_LENGTH), DVAR (GOAL_SIDE_WIDTH), DVAR (GOAL_SIDE_HEIGHT), "Right Bottom Goal Side");
	
	Geometry* leftGoalBack  = new BoxGeometry (DVAR (GOAL_BACK_LENGTH), DVAR (GOAL_BACK_WIDTH), DVAR (GOAL_BACK_HEIGHT), "Left Goal Back");

	Geometry* rightGoalBack = new BoxGeometry (DVAR (GOAL_BACK_LENGTH), DVAR (GOAL_BACK_WIDTH), DVAR (GOAL_BACK_HEIGHT), "Right Goal Back");
	
	addChild (topLong);
	addChild (bottomLong);
	addChild (leftTopShort);
	addChild (leftBottomShort);
	addChild (rightTopShort);
	addChild (rightBottomShort);
	addChild (leftTopGoalSide);
	addChild (leftBottomGoalSide);
	addChild (rightTopGoalSide);
	addChild (rightBottomGoalSide);
	addChild (leftGoalBack);
	addChild (rightGoalBack);

	topLong->            setLocalPosition ( Vector3 (VDVAR (TOP_LONG_POSITION)));
	bottomLong->         setLocalPosition ( Vector3 (VDVAR (BOTTOM_LONG_POSITION)));
	leftTopShort->       setLocalPosition (-Vector3 (VDVAR (TOP_SHORT_POSITION)));
	leftBottomShort->    setLocalPosition (-Vector3 (VDVAR (BOTTOM_SHORT_POSITION)));
	rightTopShort->      setLocalPosition ( Vector3 (VDVAR (TOP_SHORT_POSITION)));
	rightBottomShort->   setLocalPosition ( Vector3 (VDVAR (BOTTOM_SHORT_POSITION)));
	leftTopGoalSide->    setLocalPosition (-Vector3 (VDVAR (TOP_GOAL_SIDE_POSITION)));
	leftBottomGoalSide-> setLocalPosition (-Vector3 (VDVAR (BOTTOM_GOAL_SIDE_POSITION)));
	rightTopGoalSide->   setLocalPosition ( Vector3 (VDVAR (TOP_GOAL_SIDE_POSITION)));
	rightBottomGoalSide->setLocalPosition ( Vector3 (VDVAR (BOTTOM_GOAL_SIDE_POSITION)));
	leftGoalBack->       setLocalPosition (-Vector3 (VDVAR (GOAL_BACK_POSITION)));
	rightGoalBack->      setLocalPosition ( Vector3 (VDVAR (GOAL_BACK_POSITION)));

	topLong->         setLocalRotation (Matrix33::rotateAboutX (-Math::PI / 4));
	bottomLong->      setLocalRotation (Matrix33::rotateAboutX ( Math::PI / 4));
	leftTopShort->    setLocalRotation (Matrix33::rotateAboutY (-Math::PI / 4));
	leftBottomShort-> setLocalRotation (Matrix33::rotateAboutY (-Math::PI / 4));
	rightTopShort->   setLocalRotation (Matrix33::rotateAboutY ( Math::PI / 4));
	rightBottomShort->setLocalRotation (Matrix33::rotateAboutY ( Math::PI / 4));
}

Field::~Field ()
{
}
