/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#include "mmgr.h"

#include "Entity.h"
#include "Event.h"
#include "Node.h"
#include "Spatial.h"

/*******************************/

Entity::~Entity ()
{
	if (model)
	{
		Spatial* parent = model->getParent ();

		if (parent)
		{
			model->getParent ()->removeChild (model);
		}

		delete model;
	}
	
	model = 0;
}

/*******************************/

MotionController* Entity::getMotionController ()
{
	return motionController;
}

/*******************************/

Spatial* Entity::getModel ()
{
	return model;
}

/*******************************/

void Entity::think ()
{
}

/*******************************/

void Entity::touch (Entity* entity)
{
}

/*******************************/

void Entity::handleEvent (Event* event)
{
	delete event;
}

/*******************************/

Entity::Entity ()
{
}

/*******************************/
