/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifdef USE_OPENGL
#include <drawstuff/drawstuff.h>
#endif

#include "mmgr.h"

#include "CylinderGeometry.h"

CylinderGeometry::CylinderGeometry (Real length, Real radius, char* name) : Geometry (name)
{
	this->length = length;
	this->radius = radius;

	geometry  = dCreateSphere (0, radius);
	
	modelBound = BoundingSphere (Vector3::ZERO, radius + length * 0.5);
}

CylinderGeometry::~CylinderGeometry ()
{
}

void CylinderGeometry::draw ()
{
#ifdef USE_OPENGL
	dsSetColor   (color.x, color.y, color.z);
	dsSetTexture (DS_WOOD);

	dMatrix3 r;
	r[0]  = worldRotation[0][0];
	r[1]  = worldRotation[0][1];
	r[2]  = worldRotation[0][2];
	r[3]  = 0.0;
	r[4]  = worldRotation[1][0];
	r[5]  = worldRotation[1][1];
	r[6]  = worldRotation[1][2];
	r[7]  = 0.0;
	r[8]  = worldRotation[2][0];
	r[9]  = worldRotation[2][1];
	r[10] = worldRotation[2][2];
	r[11]  = 0.0;
	
	dsDrawCylinderD (worldPosition, r, length, radius);
#endif
}
