/*=========================================================================
	UberSim Source Code Release
	-------------------------------------------------------------------------
	Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
	James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
	Erick Tryzelaar {erickt}@andrew.cmu.edu
	School of Computer Science, Carnegie Mellon University
	-------------------------------------------------------------------------
	This software is distributed under the GNU General Public License,
	version 2.  If you do not have a copy of this licence, visit
	www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
	Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
	in the hope that it will be useful, but WITHOUT ANY WARRANTY,
	including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	-------------------------------------------------------------------------*/

#ifndef __SIM_VECTOR3_H__
#define __SIM_VECTOR3_H__

#include "Math.h"

class Vector3
{
	public:
		static const Vector3 ZERO;
		static const Vector3 UNIT_X;
		static const Vector3 UNIT_Y;
		static const Vector3 UNIT_Z;

	public:
		Real x;
		Real y;
		Real z;

	public:
		Vector3  ();
		Vector3  (Real x, Real y, Real z);
		Vector3  (const Real* vector);
		Vector3  (const Vector3& vector);
		~Vector3 ();

	public:
		Real& operator [] (const unsigned int i) const;
		operator Real* ();

		const bool operator == (const Vector3& vector) const;
		const bool operator != (const Vector3& vector) const;

		const Vector3& operator  = (const Vector3& vector);
		const Vector3& operator += (const Real     scalar);
		const Vector3& operator += (const Vector3& vector);
		const Vector3& operator -= (const Real     scalar);
		const Vector3& operator -= (const Vector3& vector);
		const Vector3& operator *= (const Real     scalar);
		const Vector3& operator /= (const Real     scalar);

		const Vector3 operator - () const;
		const Vector3 operator + (const Real     scalar) const;
		const Vector3 operator + (const Vector3& vector) const;
		const Vector3 operator - (const Real     scalar) const;
		const Vector3 operator - (const Vector3& vector) const;
		const Vector3 operator * (const Real     scalar) const;
		const Vector3 operator / (const Real     scalar) const;

		friend const Vector3 operator + (const Real scalar, const Vector3& vector);
		friend const Vector3 operator - (const Real scalar, const Vector3& vector);
		friend const Vector3 operator * (const Real scalar, const Vector3& vector);

	public:
		const Real    dot           (const Vector3& vector) const;
		const Vector3 cross         (const Vector3& vector) const;
		const Real    lengthSquared () const;
		const Real    length        () const;
		const Vector3 unit          () const;
		void          normalize     ();
};

#endif
