/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_VECTOR2_H__
#define __SIM_VECTOR2_H__

#include "Math.h"

class Vector2
{
	public:
		static const Vector2 ZERO;
		static const Vector2 UNIT_X;
		static const Vector2 UNIT_Y;
	
	public:
		Real x;
		Real y;
		
	public:
		Vector2  ();
		Vector2  (Real x, Real y);
		Vector2  (const Vector2& vector);
		~Vector2 ();

	public:
		Real& operator [] (const unsigned int i) const;
		operator Real* ();

		void operator  = (const Vector2& vector);
		void operator += (const Real     scalar);
		void operator += (const Vector2& vector);
		void operator -= (const Real     scalar);
		void operator -= (const Vector2& vector);
		void operator *= (const Real     scalar);

		Vector2 operator + (const Real     scalar) const;
		Vector2 operator + (const Vector2& vector) const;
		Vector2 operator - (const Real     scalar) const;
		Vector2 operator - (const Vector2& vector) const;
		Vector2 operator * (const Real     scalar) const;
		Vector2 operator / (const Real     scalar) const;
	
		friend Vector2 operator + (const Real scalar, const Vector2& vector);
		friend Vector2 operator - (const Real scalar, const Vector2& vector);
		friend Vector2 operator * (const Real scalar, const Vector2& vector);
	
	public:
		Real    dot           (const Vector2& vector) const;
		Real    lengthSquared ();
		Real    length        ();
		Vector2 unit          ();
};

#endif
