/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_TIMER_H__
#define __SIM_TIMER_H__

#include "nommgr.h"
#include <queue>
#include "mmgr.h"

class Entity;
class Event;

class Timer
{
	public:
		static Timer* getInstance ();

	public:
		~Timer ();

	public:
		void initialize ();
		void shutdown   ();

	public:
		void addEvent    (Entity* entity, Event* event, Real deltaTime);
		void clearEvents ();

	public:
		void beginFrame ();
		void frame      ();
		void endFrame   ();
		
	protected:
		Timer ();
		
	protected:
		struct Node
		{
			Entity* entity;
			Event*  event;
			Real    endTime;

			Node (Entity* entity, Event* event, Real endTime);

			bool operator > (const Node& node) const;
		};
		
	protected:
		bool isInitialized;
		bool isShutdown;
		
		std::priority_queue<Node, std::vector<Node>, std::greater<Node> > queue;
};

#endif
