/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_SURFACE_H__
#define __SIM_SURFACE_H__

#include "nommgr.h"
#include <ode/ode.h>
#include "mmgr.h"

#include "Vector3.h"

class Surface
{
	public:
		Surface ();
		Surface (const dSurfaceParameters& surfaceParameters);
		
		virtual ~Surface ();

	public:	
		dSurfaceParameters& getSurfaceParameters ();
		Vector3&            getFrictionDirection ();
		
		void setSurfaceParameters (const dSurfaceParameters& surfaceParameters);
		void setFrictionDirection (const Vector3& frictionDirection);
		
	public:
		Surface& operator += (const Surface& surface);
		
		Surface operator + (const Surface& surface);
		
	protected:
		dSurfaceParameters surfaceParameters;
		Vector3            frictionDirection;
};

#endif
