/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SPATIAL_H__
#define __SPATIAL_H__

#include "Vector3.h"
#include "Matrix33.h"

#include "BoundingSphere.h"

class MotionController;
class Node;
class RenderController;

class Spatial
{
	public:
		Spatial          (char* name);
		virtual ~Spatial ();

	public:
		char* getName   ();
		Node* getParent ();

		MotionController* getMotionController ();
		//RenderController* getRenderController ();
		
		BoundingSphere& getWorldBound ();
		
		Real&     getLocalScale           ();
		Matrix33& getLocalRotation        ();
		Vector3&  getLocalPosition        ();
		Vector3   getLocalLinearVelocity  ();
		Vector3   getLocalAngularVelocity ();

		Real&     getWorldScale           ();
		Matrix33& getWorldRotation        ();
		Vector3&  getWorldPosition        ();
		Vector3   getWorldLinearVelocity  ();
		Vector3   getWorldAngularVelocity ();

		void setParent (Node* parent);

		void setMotionController (MotionController* motionController);
		
		virtual void setLocalScale           (const Real      localScale);
		virtual void setLocalRotation        (const Matrix33& localRotation);
		virtual void setLocalPosition        (const Vector3&  localPosition);
		virtual void setLocalLinearVelocity  (const Vector3&  localLinearVelocity);
		virtual void setLocalAngularVelocity (const Vector3&  localAngularVelocity);

		virtual void setWorldScale           (const Real      worldScale);
		virtual void setWorldRotation        (const Matrix33& worldRotation);
		virtual void setWorldPosition        (const Vector3&  worldPosition);
		virtual void setWorldLinearVelocity  (const Vector3&  worldLinearVelocity);
		virtual void setWorldAngularVelocity (const Vector3&  worldAngularVelocity);
	
	public:
		virtual void updateGeometricState (Real deltaTime);
		virtual void updateWorldData      (Real deltaTime);
		virtual void updateWorldBound     () = 0;
		
		virtual void draw () = 0;

		virtual void onCollidingWith (Spatial* object);

		virtual void collidingWith (Spatial* object) = 0;

	protected:
		char* name;
		Node* parent;

		MotionController* motionController;

		BoundingSphere worldBound;
		
		bool isCalculatingTransform;
		
		Real     localScale;
		Matrix33 localRotation;
		Vector3  localPosition;
		Vector3  localLinearVelocity;
		Vector3  localAngularVelocity;

		Real     worldScale;
		Matrix33 worldRotation;
		Vector3  worldPosition;
		Vector3  worldLinearVelocity;
		Vector3  worldAngularVelocity;
};

#endif
