/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
		   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
		   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __ROBOT_H__
#define __ROBOT_H__

#include "RigidBody.h"

class Dribbler;
class Kicker;

class Robot : public RigidBody
{
	public:
		Robot          (char* name = "Robot");
		virtual ~Robot ();

	public:
		virtual void setTargetLinearVelocity  (const Vector3& targetLinearVelocity);
		virtual void setTargetAngularVelocity (const Vector3& targetAngularVelocity);

		Vector3 getTargetLinearVelocity  ();
		Vector3 getTargetAngularVelocity ();

		Dribbler* getDribbler ();
		Kicker*   getKicker   ();

	protected:
		Vector3 targetLinearVelocity;
		Vector3 targetAngularVelocity;

		Dribbler* dribbler;
		Kicker*   kicker;
};

#endif
