/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
		   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
		   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_RIGIDBODYCOLLISIONCONTROLLER_H__
#define __SIM_RIGIDBODYCOLLISIONCONTROLLER_H__

#include "CollisionController.h"

class RigidBody;
class Geometry;
class Surface;

class RigidBodyCollider : public CollisionController
{
	public:
		RigidBodyCollider (RigidBody* rigidBody);
		virtual ~RigidBodyCollider ();

	public:
		RigidBody* getRigidBody ();
		Surface*   getSurface   ();
		
		void setSurface (Surface* surface);
		
	public:
		virtual void handleCollision (Geometry* geometry, Collision& collision);

	protected:
		RigidBody* rigidBody;
		Surface*   surface;
};

#endif
