/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_RIGIDBODY_H__
#define __SIM_RIGIDBODY_H__

#include "nommgr.h"
#include <ode/ode.h>
#include "mmgr.h"

#include "MotionController.h"

class Island;
class RigidBodyCollider;
class Surface;

class RigidBody : public MotionController
{
	public:
		RigidBody          ();
		virtual ~RigidBody ();

	public:
		dBodyID& getBody ();
		
		Island* getIsland ();

		RigidBodyCollider* getRigidBodyCollider ();
		
		Vector3 getAppliedForce  ();
		Vector3 getAppliedTorque ();

		void setBody   (dBodyID& body);
		void setIsland (Island* island);

		void setRigidBodyCollider (RigidBodyCollider* rigidBodyCollider);
		
		void setAppliedForce  (const Vector3& force);
		void setAppliedTorque (const Vector3& torque);
		
		void setRollingMu (const Real rollingMu);
		
		virtual void setLocalPosition            (const Vector3&  localPosition);
		virtual void setLocalRotation            (const Matrix33& localRotation);
		virtual void setLocalVelocity            (const Vector3&  localVelocity);
		virtual void setLocalAngularVelocity     (const Vector3&  localAngularVelocity);
		virtual void setLocalAcceleration        (const Vector3&  localAcceleration);
		virtual void setLocalAngularAcceleration (const Vector3&  localAngularAcceleration);

		virtual void setWorldPosition            (const Vector3&  worldPosition);
		virtual void setWorldRotation            (const Matrix33& worldRotation);
		virtual void setWorldVelocity            (const Vector3&  worldVelocity);
		virtual void setWorldAngularVelocity     (const Vector3&  worldAngularVelocity);
		virtual void setWorldAcceleration        (const Vector3&  worldAcceleration);
		virtual void setWorldAngularAcceleration (const Vector3&  worldAngularAcceleration);

	public:
		void addForce  (const Vector3& force);
		void addTorque (const Vector3& torque);
		
	public:
		virtual void update (Real deltaTime);
		
	protected:
		Island* island;

		dBodyID body;
		Real    rollingMu;

		RigidBodyCollider* rigidBodyCollider;
};

#endif
