/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_OMNIROBOT_H__
#define __SIM_OMNIROBOT_H__

#include "RigidBodyEntity.h"
#include "Matrix33.h"
#include "Vector3.h"

class Hinge2Joint;
class RigidBody;
class RigidBodyCollider;
class SliderJoint;

class OmniRobot : public RigidBodyEntity
{
	public:
		OmniRobot          (const Vector3& color);
		virtual ~OmniRobot ();

	public:
		void handleEvent (Event* event);
		
	protected:
		RigidBody*   wheel1Body;
		RigidBody*   wheel2Body;
		RigidBody*   wheel3Body;
		
		RigidBodyCollider* wheel1Collider;
		RigidBodyCollider* wheel2Collider;
		RigidBodyCollider* wheel3Collider;
		
		Hinge2Joint* wheel1Motor;
		Hinge2Joint* wheel2Motor;
		Hinge2Joint* wheel3Motor;
		
		Hinge2Joint* dribblerMotor;
		SliderJoint* kickerMotor;

		Vector3  targetVelocity;
		Matrix33 transform;
};

#endif
