/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __NODE_H__
#define __NODE_H__

#include "nommgr.h"
#include <vector>
#include "mmgr.h"

#include "Spatial.h"

class Node : public Spatial
{
	public:
		Node          (char* name = "Node");
		virtual ~Node ();
		
	public:
		Spatial*     getChild         (unsigned int index);
		unsigned int getChildrenCount ();

	public:
		void     addChild    (Spatial* spatial);
		void     removeChild (Spatial* spatial);
		Spatial* removeChild (unsigned int index);

		unsigned int size ();

	public:
		virtual void updateWorldData  (Real deltaTime);
		virtual void updateWorldBound ();
		virtual void draw             ();
		virtual void collidingWith    (Spatial* object);
		
	protected:
		std::vector<Spatial*> children;
		unsigned int          childrenCount;
};

#endif
