/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_MOTION_CONTROLLER_H__
#define __SIM_MOTION_CONTROLLER_H__

#include "Controller.h"
#include "Matrix33.h"
#include "Vector3.h"

class Spatial;

class MotionController : Controller
{
	public:	
		MotionController ();
		virtual ~MotionController ();

	public:
		Spatial* getModel ();

		Vector3&  getLocalPosition            ();
		Matrix33& getLocalRotation            ();
		Vector3&  getLocalVelocity            ();
		Vector3&  getLocalAngularVelocity     ();
		Vector3&  getLocalAcceleration        ();
		Vector3&  getLocalAngularAcceleration ();

		Vector3&  getWorldPosition            ();
		Matrix33& getWorldRotation            ();
		Vector3&  getWorldVelocity            ();
		Vector3&  getWorldAngularVelocity     ();
		Vector3&  getWorldAcceleration        ();
		Vector3&  getWorldAngularAcceleration ();

	public:
		virtual void setModel (Spatial* model);

		virtual void setLocalPosition            (const Vector3&  localPosition);
		virtual void setLocalRotation            (const Matrix33& localRotation);
		virtual void setLocalVelocity            (const Vector3&  localVelocity);
		virtual void setLocalAngularVelocity     (const Vector3&  localAngularVelocity);
		virtual void setLocalAcceleration        (const Vector3&  localAcceleration);
		virtual void setLocalAngularAcceleration (const Vector3&  localAngularAcceleration);

		virtual void setWorldPosition            (const Vector3&  worldPosition);
		virtual void setWorldRotation            (const Matrix33& worldRotation);
		virtual void setWorldVelocity            (const Vector3&  worldVelocity);
		virtual void setWorldAngularVelocity     (const Vector3&  worldAngularVelocity);
		virtual void setWorldAcceleration        (const Vector3&  worldAcceleration);
		virtual void setWorldAngularAcceleration (const Vector3&  worldAngularAcceleration);

	public:
		virtual void update (Real deltaTime);

	protected:
		Spatial* model;

		Vector3  localVelocity;
		Vector3  localAngularVelocity;
		Vector3  localAcceleration;
		Vector3  localAngularAcceleration;

		Vector3  worldVelocity;
		Vector3  worldAngularVelocity;
		Vector3  worldAcceleration;
		Vector3  worldAngularAcceleration;
};

#endif
