/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_MATRIX33_H__
#define __SIM_MATRIX33_H__

#include "Vector3.h"

class Matrix33
{
	public:
		static const Matrix33 ZERO;
		static const Matrix33 IDENTITY;

	public:
		static Matrix33 rotateAboutX (Real a);
		static Matrix33 rotateAboutY (Real a);
		static Matrix33 rotateAboutZ (Real a);
		static Matrix33 rotate       (Real a, const Vector3& axis);
		
	public:
		Matrix33 ();
		Matrix33 (const Matrix33& matrix);
		Matrix33 (const Vector3& euler);
		Matrix33 (const Vector3& c0, const Vector3& c1, const Vector3& c2);
		Matrix33 (const Real matrix[3][3]);
		Matrix33 (const Real m00, const Real m01, const Real m02,
		          const Real m10, const Real m11, const Real m12, 
		          const Real m20, const Real m21, const Real m22);
		
		~Matrix33 ();

	public:
		Real* operator [] (const unsigned int i) const;
		//operator Real* ();

		Matrix33& operator = (const Matrix33&	matrix);	
		Matrix33& operator = (const Real*     matrix);
		
		Matrix33 operator + (const Matrix33& matrix) const;
		Matrix33 operator - (const Matrix33& matrix) const;
		Matrix33 operator * (const Real      scalar) const;
		Vector3  operator * (const Vector3&  vector) const;
		Matrix33 operator * (const Matrix33& matrix) const;

		friend Matrix33 operator * (const Real     scalar, const Matrix33& matrix);
		friend Vector3  operator * (const Vector3& vector, const Matrix33& matrix);

	public:
		Matrix33 transpose   ();
		Vector3  eulerAngles ();

	protected:
		Real m[3][3];
};

#endif
