/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_MATRIX22_H__
#define __SIM_MATRIX22_H__

#include "Vector2.h"

class Matrix22
{
	public:
		static const Matrix22 ZERO;
		static const Matrix22 IDENTITY;

	public:
		Matrix22 ();
		Matrix22 (const Matrix22& matrix);
		Matrix22 (const Real m00, const Real m01,
		          const Real m10, const Real m11);
		~Matrix22 ();

	public:
		Real* operator [] (const unsigned int i) const;
		operator Real* ();

		Matrix22& operator = (const Matrix22&	matrix);	
		
		Matrix22 operator + (const Matrix22& matrix) const;
		Matrix22 operator - (const Matrix22& matrix) const;
		Matrix22 operator * (const Real      scalar) const;
		Vector2  operator * (const Vector2&  vector) const;
		Matrix22 operator * (const Matrix22& matrix) const;

		friend Matrix22 operator * (const Real     scalar, const Matrix22& matrix);
		friend Vector2  operator * (const Vector2& vector, const Matrix22& matrix);

	public:
		Matrix22 transpose   ();

	protected:
		Real m[2][2];
};

#endif
