/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_MATH_H__
#define __SIM_MATH_H__

typedef double Real;

class Math
{
	public:
		static const Real INF;
		static const Real PI;
		static const Real TWO_PI;
		static const Real HALF_PI;
		static const Real FOURTH_PI;
		static const Real RAD_TO_DEG;
		static const Real DEG_TO_RAD;

	public:
		static Real abs  (Real r);
		static Real sign (Real r);
		static Real sqrt (Real r);
		static Real min  (Real r1, Real r2);
		static Real max  (Real r1, Real r2);

	public:
		static Real sin   (Real a);
		static Real cos   (Real a);
		static Real tan   (Real a);

		static Real asin  (Real r);
		static Real acos  (Real r);
		static Real atan  (Real r);
		static Real atan2 (Real y, Real x);
		
	public:
		static Real random ();
		static Real random (Real min, Real max);
};

#endif
