/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_ISLAND_H__
#define __SIM_ISLAND_H__

#include "nommgr.h"
#include <vector>
#include "mmgr.h"

class RigidBody;

class Island
{
	public:
		Island          ();
		virtual ~Island ();

	public:
		RigidBody*   getRigidBody      (unsigned int index);
		unsigned int getRigidBodyCount ();

	public:
		void       addRigidBody    (RigidBody*   rigidBody);
		void       removeRigidBody (RigidBody*   rigidBody);
		RigidBody* removeRigidBody (unsigned int index);

		unsigned int size ();
		
	protected:
		std::vector<RigidBody *> rigidBodies;
		unsigned int             rigidBodyCount;
};

#endif
