/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_HINGE2JOINT_H__
#define __SIM_HINGE2JOINT_H__

#include "Joint.h"
#include "Vector3.h"

class RigidBody;

class Hinge2Joint : public Joint
{
	public:
		Hinge2Joint          (RigidBody* rigidBody1, RigidBody* RigidBody2);
		virtual ~Hinge2Joint ();

	public:
		void set (char* name, char* value);

		void setAnchor         (const Vector3& anchor);
		void setAxis1          (const Vector3& axis1);
		void setAxis2          (const Vector3& axis2);
		void setMaxForce1      (const Real     maxForce1);
		void setMaxForce2      (const Real     maxForce2);
		void setTargetVelocity (const Real     velocity);

};

#endif
