/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_EVENT_H__
#define __SIM_EVENT_H__

#include "Vector3.h"
#include "Matrix33.h"

class Event
{
	public:
		Event          ();
		virtual ~Event ();
};

class FrameEvent : public Event
{
};

class KickerEvent : public Event
{
	public:
		KickerEvent (const bool isEnabled);

	public:
		bool isEnabled;
};

class DribblerEvent : public Event
{
	public:
		DribblerEvent (const bool isEnabled);

	public:
		bool isEnabled;
};

class PositionEvent : public Event
{
	public:
		PositionEvent (const Vector3& position);

	public:
		Vector3  position;
};

class RotationEvent : public Event
{
	public:
		RotationEvent (const Matrix33& rotation);

	public:
		Matrix33 rotation;
};

class VelocityEvent : public Event
{
	public:
		VelocityEvent (const Vector3& linearVelocity, const Vector3& angularVelocity);
		
	public:
		Vector3 linearVelocity;
		Vector3 angularVelocity;
};

#endif
