/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_ENGINE_H__
#define __SIM_ENGINE_H__

#include "Math.h"

class Node;

class Engine
{
	public:
		static Engine* getInstance ();

	public:
		~Engine ();

	public:
		void initialize ();
		void shutdown   ();

	public:
		Node* getRoot ();
		
		bool getIsPaused        ();
		bool getIsTakingOneStep ();
		bool getIsSkippingFrame ();
		
		Real         getStartTime   ();
		Real         getCurrentTime ();
		Real         getDeltaTime   ();
		unsigned int getFrameCount  ();
		Real         getFps         ();
		Real         getTargetFps   ();

		void setIsPaused        (bool isPaused);
		void setIsTakingOneStep (bool isTakingOneStep);
		void setTargetFps       (Real targetFps);

	public:
		void beginFrame ();
		void frame      ();
		void endFrame   ();

	protected:
		Engine ();

	protected:	
		bool isInitialized;
		bool isShutdown;

		Node* root;
	
		bool isPaused;
		bool isTakingOneStep;
		bool isSkippingFrame;

		unsigned int frameCount;
		Real         startTime;
		Real         currentTime;
		Real         previousTime;
		Real         deltaTime;
		Real         targetFps;
		Real         fps;
};

#endif
