/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __COLLIDER_H__
#define __COLLIDER_H__

#include "nommgr.h"
#include <vector>
#include "mmgr.h"

class CollisionGroup;
class Geometry;
class Node;
class Spatial;

class CollisionManager
{
	public:
		static CollisionManager* getInstance ();

	public:
		virtual ~CollisionManager ();

	public:
		void initialize ();
		void shutdown   ();
		
	public:
		void beginFrame ();
		void frame      ();
		void endFrame   ();
		
	public:
		int             addCollisionGroup    (CollisionGroup* collisionGroup);
		CollisionGroup* removeCollisionGroup (unsigned int i);
		void            removeCollisionGroup (CollisionGroup* collisionGroup);

	public:
		void addCollision (Geometry* geometry1, Spatial*  spatial2);
		void addCollision (Geometry* geometry1, Geometry* geometry2);

	protected:
		CollisionManager ();
		
	protected:
		bool isInitialized;
		bool isShutdown;

		std::vector<CollisionGroup*> collisionGroups;
};

#endif
