/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __COLLISIONGROUP_H__
#define __COLLISIONGROUP_H__

#include "nommgr.h"
#include <vector>
#include "mmgr.h"

class CollisionManager;
class Node;
class Spatial;

class CollisionGroup
{
	public:
		CollisionGroup          ();
		virtual ~CollisionGroup ();

	public:
		void addCollider (Spatial* collider);
		void addCollidee (Spatial* collidee);

		void removeCollider (unsigned int i);
		void removeCollider (Spatial* spatial);

		void removeCollidee (unsigned int i);
		void removeCollidee (Spatial* spatial);

	public:
		void testForCollisions (CollisionManager* collisionManager);

	protected:
		struct Collider
		{
			Spatial* spatial;
			Node*    parent;

			Collider ();
			Collider (Spatial* spatial);
		};
		
	protected:
		std::vector<Collider> colliders;
		std::vector<Spatial*> collidees;
};

#endif
