/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_BOUNDS_H__
#define __SIM_BOUNDS_H__

#include "Vector3.h"
#include "Matrix33.h"

class BoundingAABB
{
	public:			
		BoundingAABB          ();
		BoundingAABB          (const Vector3&      sides);
		BoundingAABB          (const BoundingAABB& bounds);
		virtual ~BoundingAABB ();

	public:
		void operator += (const BoundingAABB& bounds) = 0;

	public:
		bool isCollidingWith (const BoundingAABB& bounds) = 0;

		Bounds transformBy (Real scale, Matrix33& rotation, Vector3& position);

	protected:
		Vector3 center;
		Vector3 sides;
};

#endif
