/*=========================================================================
UberSim Source Code Release
-------------------------------------------------------------------------
Copyright (C) 2002 Manuela Veloso, Brett Browning, Mike Bowling,
                   James Bruce; {mmv, brettb, mhb, jbruce}@cs.cmu.edu
                   Erick Tryzelaar {erickt}@andrew.cmu.edu
School of Computer Science, Carnegie Mellon University
-------------------------------------------------------------------------
This software is distributed under the GNU General Public License,
version 2.  If you do not have a copy of this licence, visit
www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY,
including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
-------------------------------------------------------------------------*/

#ifndef __SIM_BOUNDINGSPHERE_H__
#define __SIM_BOUNDINGSPHERE_H__

#include "Vector3.h"
#include "Matrix33.h"

class BoundingSphere
{
	public:
		BoundingSphere          ();
		BoundingSphere          (const Vector3& center, const Real radius);
		BoundingSphere          (const BoundingSphere& bound);
		virtual ~BoundingSphere ();

	public:
		Vector3& getCenter ();
		Real&    getRadius ();

		void setCenter (const Vector3& center);
		void setRadius (const Real     radius);

	public:
		void operator += (const BoundingSphere& bound);
		
	public:
		bool isCollidingWith (BoundingSphere& bound);

		BoundingSphere transformBy (Real scale, Matrix33& rotation, Vector3& translation);

	protected:
		Vector3 center;
		Real    radius;
};

#endif // __BOUNDINGVOLUME_H__
