#ifndef __NET_REFEREE_H__
#define __NET_REFEREE_H__

#include "reality/net_vision.h"
#include "reality/net_radio.h"

#define NET_REFEREE_PROTOCOL   Socket::TCP
#define NET_REFEREE_PORT       32999

// Currently a referee command encapsulates either a radio message
// or a vision message.

struct NetRefereeMsg {
  enum {
    VCONFIG,
    VSIM,
    VREF
  };

  NetRefereeMsg() {}
  NetRefereeMsg(net_vconfig m) : msg_type(VCONFIG), vconfig(m) {}
  NetRefereeMsg(net_vsim m) : msg_type(VSIM), vsim(m) {}
  NetRefereeMsg(net_vref m) : msg_type(VREF), vref(m) {}

  char msg_type;
  union {
    net_vconfig vconfig;
    net_vsim vsim;
    net_vref vref;
  };
};


#endif
