/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainWindow
implements ActionListener,
ItemListener,
AdjustmentListener {
    static volatile int commandVal;
    JButton sendFrame_b;
    JButton saveFrame_b;
    Thread updateThread;
    static CameraImage cImage;
    volatile Motion myMotion;
    volatile ColorTrack myColor;
    volatile Histogram myHistogram;
    volatile Stats myStats;
    AboutWindow myAbout;
    int file_cnt = 0;
    int msg_cnt = 0;
    JMenu images_m;
    JMenuBar menuBar;
    JFrame pref_f;
    JFrame scale_f;
    static JTextField thresh_t;
    static JTextField nf_t;
    static JTextField rmin_t;
    static JTextField gmin_t;
    static JTextField bmin_t;
    static JTextField rmax_t;
    static JTextField gmax_t;
    static JTextField bmax_t;
    static JTextArea path_crl_t;
    static JTextField tol_t;
    static JTextField time_t;
    static JTextField size_t;
    static JTextField port_t;
    JButton setParams_b;
    static JPanel cam_p;
    static JPanel stats_p;
    static JPanel configb_p;
    static JPanel config_p;
    static JPanel settings_p;
    static JPanel servo_p;
    static JTextField xpos_t;
    static JTextField ypos_t;
    static JTextField status_t;
    static JLabel servo0_l;
    static JLabel servo1_l;
    static JLabel servo2_l;
    static JLabel servo3_l;
    static JLabel servo4_l;
    static JScrollBar servo0_s;
    static JScrollBar servo1_s;
    static JScrollBar servo2_s;
    static JScrollBar servo3_s;
    static JScrollBar servo4_s;
    static JPanel JPanel1;
    static JComboBox whiteBalance;
    static JComboBox autoGain;
    static JComboBox fps;
    static JComboBox channel_c;
    static JComboBox hr_c;
    static JComboBox lm_c;
    static JComboBox as_c;
    static JComboBox color_c;
    static JComboBox bm_c;
    static JComboBox sf_chan_c;
    static JComboBox pd_c;
    static JComboBox ti_c;
    static JComboBox fs_c;
    static JComboBox hd_c;
    static JComboBox dc_c;
    static JLabel cFPS_l;
    static JLabel mFPS_l;
    static JLabel sFPS_l;
    static JLabel hFPS_l;
    JButton clear_b;
    static CameraSerial mySerial;
    static int cameraType;
    static int cameraVersion;
    static int track_color_linemode;
    static int get_mean_linemode;
    static int frame_diff_linemode;
    static JTextField rmean_l;
    static JTextField gmean_l;
    static JTextField bmean_l;
    static JTextField x1;
    static JTextField y1;
    static JTextField x2;
    static JTextField y2;
    static JTextField dsx;
    static JTextField dsy;
    static JTextField pan_range_far;
    static JTextField pan_range_near;
    static JTextField pan_step;
    static JTextField tilt_range_far;
    static JTextField tilt_range_near;
    static JTextField tilt_step;
    volatile int res = 0;
    JButton send_command_b;
    static JProgressBar frameProg;

    MainWindow() {
        track_color_linemode = 0;
        get_mean_linemode = 0;
        frame_diff_linemode = 0;
        CommWindow commWindow = new CommWindow();
        while (commWindow.ready() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        JPanel1 = new JPanel();
        this.myAbout = new AboutWindow();
        JFrame jFrame = new JFrame("CMUcam2 GUI");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.setDefaultCloseOperation(3);
        cam_p = new JPanel();
        config_p = new JPanel();
        tol_t = new JTextField("25", 5);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Select Tolerance"));
        jPanel.add(tol_t);
        this.clear_b = new JButton("clear");
        jPanel.add(this.clear_b);
        this.clear_b.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        settings_p = new JPanel();
        GridLayout gridLayout = new GridLayout(13, 3);
        gridLayout.setVgap(10);
        gridLayout.setHgap(10);
        settings_p.setLayout(gridLayout);
        JLabel jLabel = new JLabel("Color Space");
        color_c = new JComboBox();
        color_c.addItem("RGB");
        color_c.addItem("YCrCb");
        color_c.addItemListener(this);
        settings_p.add(jLabel);
        settings_p.add(color_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel2 = new JLabel("White Balance");
        whiteBalance = new JComboBox();
        whiteBalance.addItem("Off");
        whiteBalance.addItem("On");
        whiteBalance.addItemListener(this);
        settings_p.add(jLabel2);
        settings_p.add(whiteBalance);
        settings_p.add(new JLabel(""));
        JLabel jLabel3 = new JLabel("Auto Gain");
        autoGain = new JComboBox();
        autoGain.addItem("On");
        autoGain.addItem("Off");
        autoGain.addItemListener(this);
        settings_p.add(jLabel3);
        settings_p.add(autoGain);
        settings_p.add(new JLabel(""));
        JLabel jLabel4 = new JLabel("Camera Resolution");
        hr_c = new JComboBox();
        hr_c.addItem("Low");
        hr_c.addItem("High");
        hr_c.addItemListener(this);
        settings_p.add(jLabel4);
        settings_p.add(hr_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel5 = new JLabel("Pixel Difference");
        pd_c = new JComboBox();
        pd_c.addItem("Off");
        pd_c.addItem("On");
        pd_c.addItemListener(this);
        settings_p.add(jLabel5);
        settings_p.add(pd_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel6 = new JLabel("Inverted Tracking");
        ti_c = new JComboBox();
        ti_c.addItem("Off");
        ti_c.addItem("On");
        ti_c.addItemListener(this);
        settings_p.add(jLabel6);
        settings_p.add(ti_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel7 = new JLabel("Frame Stream");
        fs_c = new JComboBox();
        fs_c.addItem("Off");
        fs_c.addItem("On");
        fs_c.addItemListener(this);
        settings_p.add(jLabel7);
        settings_p.add(fs_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel8 = new JLabel("HiRes Frame Diff");
        hd_c = new JComboBox();
        hd_c.addItem("Off");
        hd_c.addItem("On");
        hd_c.addItemListener(this);
        settings_p.add(jLabel8);
        settings_p.add(hd_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel9 = new JLabel("Diff Channel");
        dc_c = new JComboBox();
        dc_c.addItem("Red");
        dc_c.addItem("Green");
        dc_c.addItem("Blue");
        settings_p.add(jLabel9);
        settings_p.add(dc_c);
        settings_p.add(new JLabel(""));
        dc_c.setSelectedIndex(1);
        dc_c.addItemListener(this);
        JLabel jLabel10 = new JLabel("Line Modes");
        lm_c = new JComboBox();
        lm_c.addItem("Off");
        lm_c.addItem("Track Color-Bitmap");
        lm_c.addItem("Track Color-Stats");
        lm_c.addItem("Get Mean data");
        lm_c.addItem("Get Mean data-stats");
        lm_c.addItem("Frame Diff-Bitmap");
        lm_c.addItem("Frame Diff-Deltas");
        lm_c.addItem("Frame Diff-Buffer");
        lm_c.addItemListener(this);
        settings_p.add(jLabel10);
        settings_p.add(lm_c);
        settings_p.add(new JLabel(""));
        JLabel jLabel11 = new JLabel("Buffer Mode");
        bm_c = new JComboBox();
        bm_c.addItem("Stream");
        bm_c.addItem("Single");
        bm_c.addItemListener(this);
        settings_p.add(jLabel11);
        settings_p.add(bm_c);
        JButton jButton = new JButton("read frame");
        settings_p.add(jButton);
        jButton.addActionListener(this);
        JLabel jLabel12 = new JLabel("Noise Filter");
        nf_t = new JTextField("2", 5);
        settings_p.add(jLabel12);
        settings_p.add(nf_t);
        JButton jButton2 = new JButton("Set NF");
        settings_p.add(jButton2);
        jButton2.addActionListener(this);
        JLabel jLabel13 = new JLabel("Update All Parameters");
        settings_p.add(jLabel13);
        JButton jButton3 = new JButton("Update ALL");
        settings_p.add(jButton3);
        jButton3.addActionListener(this);
        settings_p.add(new JLabel(""));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", settings_p);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("Virtual Window:"));
        x1 = new JTextField("100", 5);
        y1 = new JTextField("100", 5);
        x2 = new JTextField("100", 5);
        y2 = new JTextField("100", 5);
        jPanel4.add(x1);
        jPanel4.add(y1);
        jPanel4.add(x2);
        jPanel4.add(y2);
        JButton jButton4 = new JButton("Set Window");
        jPanel4.add(jButton4);
        jButton4.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel("Down Sampling:"));
        jPanel5.add(new JLabel("X Axis:"));
        dsx = new JTextField("1", 5);
        jPanel5.add(dsx);
        jPanel5.add(new JLabel("Y Axis:"));
        dsy = new JTextField("1", 5);
        jPanel5.add(dsy);
        JButton jButton5 = new JButton("Down Sample");
        jPanel5.add(jButton5);
        jButton5.addActionListener(this);
        jPanel3.add("North", jPanel5);
        jPanel3.add("South", jPanel4);
        jPanel2.add("South", jPanel3);
        JPanel jPanel6 = new JPanel();
        servo_p = new JPanel();
        GridLayout gridLayout2 = new GridLayout(12, 3);
        gridLayout2.setVgap(10);
        gridLayout2.setHgap(10);
        servo_p.setLayout(gridLayout2);
        JLabel jLabel14 = new JLabel("Auto Servo");
        as_c = new JComboBox();
        as_c.addItem("Off");
        as_c.addItem("On");
        as_c.addItemListener(this);
        servo_p.add(jLabel14);
        servo_p.add(as_c);
        servo_p.add(new JLabel(""));
        JLabel jLabel15 = new JLabel("Servo 0:");
        servo0_s = new JScrollBar(0, 127, 1, 0, 255);
        JLabel jLabel16 = new JLabel("Servo 1:");
        servo1_s = new JScrollBar(0, 127, 1, 0, 255);
        JLabel jLabel17 = new JLabel("Servo 2:");
        servo2_s = new JScrollBar(0, 127, 1, 0, 255);
        JLabel jLabel18 = new JLabel("Servo 3:");
        servo3_s = new JScrollBar(0, 127, 1, 0, 255);
        JLabel jLabel19 = new JLabel("Servo 4:");
        servo4_s = new JScrollBar(0, 127, 1, 0, 255);
        servo0_l = new JLabel("127");
        servo1_l = new JLabel("127");
        servo2_l = new JLabel("127");
        servo3_l = new JLabel("127");
        servo4_l = new JLabel("127");
        servo_p.add(jLabel15);
        servo_p.add(servo0_s);
        servo_p.add(servo0_l);
        servo_p.add(jLabel16);
        servo_p.add(servo1_s);
        servo_p.add(servo1_l);
        servo_p.add(jLabel17);
        servo_p.add(servo2_s);
        servo_p.add(servo2_l);
        servo_p.add(jLabel18);
        servo_p.add(servo3_s);
        servo_p.add(servo3_l);
        servo_p.add(jLabel19);
        servo_p.add(servo4_s);
        servo_p.add(servo4_l);
        servo0_s.addAdjustmentListener(this);
        servo1_s.addAdjustmentListener(this);
        servo2_s.addAdjustmentListener(this);
        servo3_s.addAdjustmentListener(this);
        servo4_s.addAdjustmentListener(this);
        pan_range_far = new JTextField("16", 5);
        pan_range_near = new JTextField("8", 5);
        pan_step = new JTextField("5", 5);
        tilt_range_far = new JTextField("30", 5);
        tilt_range_near = new JTextField("15", 5);
        tilt_step = new JTextField("5", 5);
        servo_p.add(new JLabel("pan range far:"));
        servo_p.add(pan_range_far);
        servo_p.add(new JLabel(""));
        servo_p.add(new JLabel("pan range near:"));
        servo_p.add(pan_range_near);
        servo_p.add(new JLabel(""));
        servo_p.add(new JLabel("pan step:"));
        servo_p.add(pan_step);
        servo_p.add(new JLabel(""));
        servo_p.add(new JLabel("tilt range far:"));
        servo_p.add(tilt_range_far);
        servo_p.add(new JLabel(""));
        servo_p.add(new JLabel("tilt range near:"));
        servo_p.add(tilt_range_near);
        servo_p.add(new JLabel(""));
        servo_p.add(new JLabel("tilt step:"));
        servo_p.add(tilt_step);
        JButton jButton6 = new JButton("Config Servos");
        servo_p.add(jButton6);
        jButton6.addActionListener(this);
        this.myStats = new Stats();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.add(new JLabel("FPS"));
        sFPS_l = new JLabel("0");
        jPanel8.add(sFPS_l);
        jPanel8.add(new JLabel("      "));
        JLabel jLabel20 = new JLabel("RGB:");
        jPanel8.add(jLabel20);
        rmean_l = new JTextField("0", 5);
        jPanel8.add(rmean_l);
        gmean_l = new JTextField("0", 5);
        jPanel8.add(gmean_l);
        bmean_l = new JTextField("0", 5);
        jPanel8.add(bmean_l);
        JButton jButton7 = new JButton("Get Mean");
        jPanel8.add(jButton7);
        jButton7.addActionListener(this);
        jPanel7.add("Center", this.myStats);
        jPanel7.add("South", jPanel8);
        this.myHistogram = new Histogram();
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        JPanel jPanel10 = new JPanel();
        jPanel10.add(new JLabel("FPS"));
        hFPS_l = new JLabel("0");
        jPanel10.add(hFPS_l);
        jPanel10.add(new JLabel("      "));
        channel_c = new JComboBox();
        channel_c.addItem("Red (Cr)");
        channel_c.addItem("Green (Y)");
        channel_c.addItem("Blue (Cb)");
        channel_c.addItemListener(this);
        jPanel10.add(channel_c);
        JButton jButton8 = new JButton("Get Histogram");
        jPanel10.add(jButton8);
        jButton8.addActionListener(this);
        jPanel9.add("Center", this.myHistogram);
        jPanel9.add("South", jPanel10);
        this.myColor = new ColorTrack();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        rmin_t = new JTextField("0", 5);
        gmin_t = new JTextField("0", 5);
        bmin_t = new JTextField("0", 5);
        rmax_t = new JTextField("0", 5);
        gmax_t = new JTextField("0", 5);
        bmax_t = new JTextField("0", 5);
        jPanel12.add(new JLabel("min:"));
        jPanel12.add(rmin_t);
        jPanel12.add(gmin_t);
        jPanel12.add(bmin_t);
        jPanel12.add(new JLabel("max:"));
        jPanel12.add(rmax_t);
        jPanel12.add(gmax_t);
        jPanel12.add(bmax_t);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        JPanel jPanel14 = new JPanel();
        jPanel14.add(new JLabel("FPS:"));
        cFPS_l = new JLabel("0");
        jPanel14.add(cFPS_l);
        jPanel14.add(new JLabel("     "));
        JButton jButton9 = new JButton("Track Color");
        jPanel14.add(jButton9);
        jButton9.addActionListener(this);
        JButton jButton10 = new JButton("Track Window");
        jPanel14.add(jButton10);
        jButton10.addActionListener(this);
        jPanel13.add("Center", jPanel12);
        jPanel13.add("South", jPanel14);
        jPanel11.add("Center", this.myColor);
        jPanel11.add("South", jPanel13);
        this.myMotion = new Motion();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        jPanel16.add(new JLabel("FPS"));
        mFPS_l = new JLabel("0");
        jPanel16.add(mFPS_l);
        jPanel16.add(new JLabel("     "));
        jPanel15.setLayout(new BorderLayout());
        thresh_t = new JTextField("15", 5);
        jPanel16.add(new JLabel("Threshold:"));
        jPanel16.add(thresh_t);
        JButton jButton11 = new JButton("Load Frame");
        jPanel16.add(jButton11);
        jButton11.addActionListener(this);
        JButton jButton12 = new JButton("Frame Diff");
        jPanel16.add(jButton12);
        jButton12.addActionListener(this);
        jPanel15.add("Center", this.myMotion);
        jPanel15.add("South", jPanel16);
        cImage = new CameraImage(352, 288);
        JPanel jPanel17 = new JPanel();
        JPanel jPanel18 = new JPanel();
        this.sendFrame_b = new JButton("Grab Frame");
        this.saveFrame_b = new JButton("Save Frame");
        frameProg = new JProgressBar(0, 144);
        frameProg.setValue(0);
        frameProg.setStringPainted(true);
        frameProg.setOrientation(0);
        frameProg.setStringPainted(false);
        sf_chan_c = new JComboBox();
        sf_chan_c.addItem("All");
        sf_chan_c.addItem("red");
        sf_chan_c.addItem("green");
        sf_chan_c.addItem("blue");
        this.sendFrame_b.addActionListener(this);
        this.saveFrame_b.addActionListener(this);
        jPanel17.add(sf_chan_c);
        jPanel17.add(this.sendFrame_b);
        jPanel17.add(this.saveFrame_b);
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.makeMenuItem("About"));
        jMenu.add(this.makeMenuItem("Quit"));
        this.images_m = new JMenu("Image", true);
        this.images_m.add(this.makeMenuItem("Flip Vertical"));
        this.images_m.add(this.makeMenuItem("Flip Horizontal"));
        this.images_m.add(this.makeMenuItem("Red Channel"));
        this.images_m.add(this.makeMenuItem("Green Channel"));
        this.images_m.add(this.makeMenuItem("Blue Channel"));
        this.images_m.add(this.makeMenuItem("All Channels"));
        JPanel jPanel19 = new JPanel();
        this.menuBar.add(jMenu);
        this.menuBar.add(this.images_m);
        jFrame.setJMenuBar(this.menuBar);
        jPanel19.setLayout(new BorderLayout());
        jPanel19.add("Center", cImage);
        JPanel jPanel20 = new JPanel();
        GridLayout gridLayout3 = new GridLayout(2, 1);
        jPanel20.setLayout(gridLayout3);
        jPanel20.add(jPanel);
        jPanel20.add(jPanel17);
        jPanel18.setLayout(new BorderLayout());
        jPanel18.add((Component)jPanel20, "Center");
        jPanel18.add((Component)frameProg, "South");
        JPanel1.add(jPanel18);
        jPanel19.add("South", JPanel1);
        jTabbedPane.addTab("Camera View", jPanel19);
        jTabbedPane.addTab("Config", jPanel2);
        jTabbedPane.addTab("Color", jPanel11);
        jTabbedPane.addTab("Motion", jPanel15);
        jTabbedPane.addTab("Histogram", jPanel9);
        jTabbedPane.addTab("Stats", jPanel7);
        jTabbedPane.addTab("Servo", servo_p);
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MainWindow.this.stopCameraStuff();
            }
        });
        JPanel jPanel21 = new JPanel();
        jPanel21.add(new JLabel("Console:"));
        status_t = new JTextField(25);
        jPanel21.add(status_t);
        JButton jButton13 = new JButton("STOP");
        jPanel21.add(jButton13);
        jButton13.addActionListener(this);
        JButton jButton14 = new JButton("RESET");
        jPanel21.add(jButton14);
        jButton14.addActionListener(this);
        JButton jButton15 = new JButton("Clear");
        jPanel21.add(jButton15);
        jButton15.addActionListener(this);
        JButton jButton16 = new JButton("Send");
        jPanel21.add(jButton16);
        jButton16.addActionListener(this);
        jFrame.getContentPane().add((Component)jPanel21, "North");
        jFrame.getContentPane().add((Component)jTabbedPane, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
        mySerial = new CameraSerial(commWindow.getPort());
        if (cameraType == 6) {
            x1.setText("1");
            y1.setText("1");
            x2.setText("87");
            y2.setText("142");
        } else {
            x1.setText("1");
            y1.setText("1");
            x2.setText("159");
            y2.setText("238");
        }
        commandVal = 0;
        while (true) {
            if (commandVal == 1) {
                this.myMotion.trackMotion(hd_c.getSelectedIndex());
                continue;
            }
            if (commandVal == 2) {
                this.myHistogram.getHistogram();
                continue;
            }
            if (commandVal == 3) {
                this.myColor.trackColor();
                continue;
            }
            if (commandVal == 4) {
                this.myStats.getMean();
                continue;
            }
            if (commandVal == 5 || commandVal == 6) {
                cImage.sendFrame(sf_chan_c.getSelectedIndex());
                continue;
            }
            if (commandVal == -1) {
                this.stopCameraStuff();
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (commandVal != 0) {
            commandVal = -1;
            while (commandVal == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (string.equals("Flip Horizontal")) {
            cImage.flip(0);
            MainWindow.cImage.flipx = MainWindow.cImage.flipx == 0 ? 1 : 0;
        } else if (string.equals("Flip Vertical")) {
            cImage.flip(1);
            MainWindow.cImage.flipy = MainWindow.cImage.flipy == 0 ? 1 : 0;
        } else if (string.equals("Red Channel")) {
            cImage.setChannel(0);
        } else if (string.equals("Green Channel")) {
            cImage.setChannel(1);
        } else if (string.equals("Blue Channel")) {
            cImage.setChannel(2);
        } else if (string.equals("All Channels")) {
            cImage.setChannel(4);
        } else if (string.equals("Quit")) {
            System.exit(0);
        } else if (string.equals("About")) {
            this.myAbout.about_f.pack();
            this.myAbout.about_d.setVisible(true);
        } else if (string.equals("STOP")) {
            status_t.setText("Stopping...");
            commandVal = -1;
        } else if (string.equals("Send")) {
            mySerial.write(status_t.getText() + "\r");
            status_t.setText("Command Sent");
        } else if (string.equals("Config Servos")) {
            status_t.setText("Servo Configure Called");
            mySerial.write("sp " + pan_range_far.getText() + " " + pan_range_near.getText() + " " + pan_step.getText() + " " + tilt_range_far.getText() + " " + tilt_range_near.getText() + " " + tilt_step.getText());
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Servos Set.");
            } else {
                status_t.setText("Servo Config Failed.");
            }
        } else if (string.equals("Clear")) {
            status_t.setText("");
        } else if (string.equals("RESET")) {
            commandVal = 0;
            as_c.setSelectedIndex(0);
            hr_c.setSelectedIndex(0);
            lm_c.setSelectedIndex(0);
            whiteBalance.setSelectedIndex(0);
            autoGain.setSelectedIndex(0);
            color_c.setSelectedIndex(0);
            bm_c.setSelectedIndex(0);
            hd_c.setSelectedIndex(0);
            ti_c.setSelectedIndex(0);
            pd_c.setSelectedIndex(0);
            dc_c.setSelectedIndex(1);
            mySerial.readACK(0);
            this.setWindowParams();
            mySerial.write("rs\r");
            mySerial.readACK(0);
            status_t.setText("Camera Reset...");
        } else if (string.equals("Grab Frame")) {
            if (fs_c.getSelectedIndex() == 1) {
                int n = sf_chan_c.getSelectedIndex();
                if (n == 0) {
                    mySerial.write("sf\r");
                } else {
                    mySerial.write("sf " + (n - 1) + "\r");
                }
                commandVal = 5;
            } else {
                commandVal = 6;
            }
        } else if (string.equals("Save Frame")) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(new JFrame("Type the name of the File to save"));
            File file = jFileChooser.getSelectedFile();
            if (n == 0) {
                cImage.writeImage(file + ".jpg");
            }
        } else if (string.equals("clear")) {
            MainWindow.cImage.objnum = 0;
            MainWindow.cImage.my_drive = 0.0;
            MainWindow.cImage.target_x = 0;
            MainWindow.cImage.target_y = 0;
            CameraImage.objDirt[0] = 0;
            CameraImage.objDirt[1] = 0;
            CameraImage.objDirt[2] = 0;
            cImage.repaint();
        } else if (string.equals("Get Mean")) {
            status_t.setText("Get Mean");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Get Mean Failed");
                return;
            }
            mySerial.write("gm\r");
            status_t.setText("Get Mean ");
            commandVal = 4;
        } else if (string.equals("read frame")) {
            mySerial.write("rf");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Read Frame Failed");
                return;
            }
            status_t.setText("New Frame Loaded...");
        } else if (string.equals("Load Frame")) {
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Load Frame Failed");
                return;
            }
            mySerial.write("lf");
            if (frame_diff_linemode == 3) {
                mySerial.write("\r");
                this.myMotion.trackMotion(hd_c.getSelectedIndex());
            } else if (mySerial.readACK(1) == 0) {
                status_t.setText("Load Frame Failed");
                return;
            }
            status_t.setText("Frame Loaded...");
        } else if (string.equals("Set Window")) {
            status_t.setText("Set Virtual Window Called");
            mySerial.write("vw " + x1.getText() + " " + y1.getText() + " " + x2.getText() + " " + y2.getText());
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Virtual Window Set.");
            } else {
                status_t.setText("Virtual Window Failed.");
            }
        } else if (string.equals("Down Sample")) {
            status_t.setText("Down Sampling Called");
            mySerial.write("ds " + dsx.getText() + " " + dsy.getText());
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Down Sampling Set.");
            } else {
                status_t.setText("Down Sampling Failed.");
            }
        } else if (string.equals("Track Color")) {
            status_t.setText("Track Color Called");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Tracking Failed");
                return;
            }
            mySerial.write("tc " + rmin_t.getText() + " " + rmax_t.getText() + " " + gmin_t.getText() + " " + gmax_t.getText() + " " + bmin_t.getText() + " " + bmax_t.getText() + "\r");
            status_t.setText("Tracking Color ");
            commandVal = 3;
        } else if (string.equals("Track Window")) {
            status_t.setText("Track Window Called");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Tracking Failed");
                return;
            }
            mySerial.write("tw\r");
            this.setWindowParams();
            status_t.setText("Tracking Window ");
            commandVal = 3;
        } else if (string.equals("Update ALL")) {
            this.UpdateAllCommands();
        } else if (string.equals("Set NF")) {
            status_t.setText("Setting Noise Filter");
            mySerial.write("nf " + nf_t.getText());
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Noise Filter Set.");
            } else {
                status_t.setText("Noise Filter Failed.");
            }
        } else if (string.equals("Frame Diff")) {
            status_t.setText("Frame Diff Called");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Tracking Failed");
                return;
            }
            mySerial.write("fd " + thresh_t.getText() + "\r");
            status_t.setText("Motion Track " + thresh_t.getText());
            commandVal = 1;
        } else if (string.equals("Get Histogram")) {
            status_t.setText("Get Histogram");
            if (mySerial.readACK(0) == 0) {
                status_t.setText("Histogram Failed");
                return;
            }
            mySerial.write("gh " + channel_c.getSelectedIndex() + "\r");
            status_t.setText("Get Histogram " + channel_c.getSelectedIndex());
            commandVal = 2;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (commandVal != 0) {
            commandVal = -1;
            while (commandVal == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        status_t.setText("Setting Servos");
        mySerial.write("sv 0 " + servo0_s.getValue() + "\r");
        mySerial.write("sv 1 " + servo1_s.getValue() + "\r");
        mySerial.write("sv 2 " + servo2_s.getValue() + "\r");
        mySerial.write("sv 3 " + servo3_s.getValue() + "\r");
        mySerial.write("sv 4 " + servo4_s.getValue() + "\r");
        servo0_l.setText(new Integer(servo0_s.getValue()).toString());
        servo1_l.setText(new Integer(servo1_s.getValue()).toString());
        servo2_l.setText(new Integer(servo2_s.getValue()).toString());
        servo3_l.setText(new Integer(servo3_s.getValue()).toString());
        servo4_l.setText(new Integer(servo4_s.getValue()).toString());
        status_t.setText("Servos Set");
    }

    private void setWindowParams() {
        if (this.res == 0) {
            if (cameraType == 6) {
                x1.setText("1");
                y1.setText("1");
                x2.setText("87");
                y2.setText("142");
            } else {
                x1.setText("1");
                y1.setText("1");
                x2.setText("159");
                y2.setText("238");
            }
        } else {
            x2.setText("174");
            y2.setText("254");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (commandVal != 0) {
            commandVal = -1;
            while (commandVal == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (itemSelectable == autoGain) {
            status_t.setText("Setting Auto Gain");
            int n = autoGain.getSelectedIndex() == 0 ? 33 : 32;
            mySerial.write("cr 19 " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Registers Set.");
            } else {
                status_t.setText("Registers Failed.");
            }
        } else if (itemSelectable == whiteBalance || itemSelectable == color_c) {
            int n = color_c.getSelectedIndex() == 0 ? (whiteBalance.getSelectedIndex() == 0 ? 40 : 44) : (whiteBalance.getSelectedIndex() == 0 ? 32 : 36);
            status_t.setText("Setting Color and WB");
            mySerial.write("cr 18 " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Registers Set.");
            } else {
                status_t.setText("Registers Failed.");
            }
        } else if (itemSelectable == hr_c) {
            if (hr_c.getSelectedIndex() == 0) {
                this.res = 0;
                status_t.setText("Setting Res Low");
            } else {
                if (cameraType == 7) {
                    status_t.setText("Option not available");
                    return;
                }
                this.res = 1;
                status_t.setText("Setting Res High");
            }
            mySerial.write("hr " + this.res);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Registers Set.");
                this.setWindowParams();
            } else {
                status_t.setText("Registers Failed.");
            }
        } else if (itemSelectable == as_c) {
            int n = as_c.getSelectedIndex() == 0 ? 0 : 1;
            mySerial.write("sm " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Auto Servo Mode set.");
            } else {
                status_t.setText("Auto Servo Mode failed.");
            }
        } else if (itemSelectable == pd_c) {
            int n = pd_c.getSelectedIndex() == 0 ? 0 : 1;
            mySerial.write("pd " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Pixel Differencing set.");
            } else {
                status_t.setText("Pixel Differencing failed.");
            }
        } else if (itemSelectable == ti_c) {
            int n = ti_c.getSelectedIndex() == 0 ? 0 : 1;
            mySerial.write("ti " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Inverted Tracking set.");
            } else {
                status_t.setText("Inverted Tracking failed.");
            }
        } else if (itemSelectable == fs_c) {
            int n = fs_c.getSelectedIndex() == 0 ? 0 : 1;
            mySerial.write("fs " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Frame Stream set.");
            } else {
                status_t.setText("Frame Stream failed.");
            }
        } else if (itemSelectable == hd_c) {
            int n = hd_c.getSelectedIndex() == 0 ? 0 : 1;
            mySerial.write("hd " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("HiRes Diff Mode set.");
            } else {
                status_t.setText("HiRes Diff Mode failed.");
            }
        } else if (itemSelectable == dc_c) {
            mySerial.write("dc " + dc_c.getSelectedIndex());
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Diff Channel Set");
            } else {
                status_t.setText("Diff Channel Failed");
            }
        } else if (itemSelectable == bm_c) {
            int n;
            if (bm_c.getSelectedIndex() == 0) {
                n = 0;
                status_t.setText("Setting buffer mode auto stream");
            } else {
                n = 1;
                status_t.setText("Setting buffer mode manual reload");
            }
            mySerial.write("bm " + n);
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Buffer Mode Set.");
            } else {
                status_t.setText("Buffer Mode Failed.");
            }
        } else if (itemSelectable == lm_c) {
            track_color_linemode = 0;
            get_mean_linemode = 0;
            frame_diff_linemode = 0;
            switch (lm_c.getSelectedIndex()) {
                case 0: {
                    boolean bl = false;
                    status_t.setText("All line modes off");
                    mySerial.write("lm 0 0");
                    mySerial.readACK(1);
                    mySerial.write("lm 1 0");
                    mySerial.readACK(1);
                    mySerial.write("lm 2 0");
                    break;
                }
                case 1: {
                    status_t.setText("Line Mode Track Color Bitmap on");
                    mySerial.write("lm 0 1");
                    track_color_linemode = 1;
                    break;
                }
                case 2: {
                    status_t.setText("Line Mode Track Color Stats on");
                    mySerial.write("lm 0 2");
                    track_color_linemode = 2;
                    break;
                }
                case 3: {
                    status_t.setText("Line Mode Get Mean on");
                    mySerial.write("lm 1 1");
                    get_mean_linemode = 1;
                    break;
                }
                case 4: {
                    status_t.setText("Line Mode Get Mean Stats on");
                    mySerial.write("lm 1 2");
                    get_mean_linemode = 2;
                    break;
                }
                case 5: {
                    status_t.setText("Line Mode Frame Diff Bitmap on");
                    mySerial.write("lm 2 1");
                    frame_diff_linemode = 1;
                    break;
                }
                case 6: {
                    status_t.setText("Line Mode Frame Diff Deltas on");
                    mySerial.write("lm 2 2");
                    frame_diff_linemode = 2;
                    break;
                }
                case 7: {
                    status_t.setText("Line Mode Frame Diff Buffer on");
                    mySerial.write("lm 2 3");
                    frame_diff_linemode = 3;
                    break;
                }
            }
            if (mySerial.readACK(1) == 1) {
                status_t.setText("Registers Set.");
            } else {
                status_t.setText("Registers Failed.");
            }
        }
        String string = itemEvent.getItem().toString();
        int n = itemEvent.getStateChange();
        if (string.equals("Color Picker")) {
            // empty if block
        }
        if (string.equals("Color Track")) {
            // empty if block
        }
    }

    private JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private void stopCameraStuff() {
        this.myMotion.stop();
        this.myHistogram.stop();
        this.myColor.stop();
        this.myStats.stop();
        commandVal = 0;
        mySerial.write("\r");
        status_t.setText("Camera Ready...");
    }

    private void UpdateAllCommands() {
        int n;
        mySerial.write("lm 0 0");
        mySerial.readACK(1);
        mySerial.write("lm 1 0");
        mySerial.readACK(1);
        mySerial.write("lm 2 0");
        switch (lm_c.getSelectedIndex()) {
            case 1: {
                mySerial.write("lm 0 1");
                track_color_linemode = 1;
                break;
            }
            case 2: {
                mySerial.write("lm 0 2");
                track_color_linemode = 2;
                break;
            }
            case 3: {
                mySerial.write("lm 1 1");
                get_mean_linemode = 1;
                break;
            }
            case 4: {
                mySerial.write("lm 1 2");
                get_mean_linemode = 2;
                break;
            }
            case 5: {
                mySerial.write("lm 2 1");
                frame_diff_linemode = 1;
                break;
            }
            case 6: {
                mySerial.write("lm 2 2");
                frame_diff_linemode = 2;
                break;
            }
            case 7: {
                mySerial.write("lm 2 3");
                frame_diff_linemode = 3;
                break;
            }
        }
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n2 = autoGain.getSelectedIndex() == 0 ? 33 : 32;
        mySerial.write("cr 19 " + n2);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n3 = color_c.getSelectedIndex() == 0 ? (whiteBalance.getSelectedIndex() == 0 ? 40 : 44) : (whiteBalance.getSelectedIndex() == 0 ? 32 : 36);
        mySerial.write("cr 18 " + n3);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        if (hr_c.getSelectedIndex() == 0) {
            this.res = 0;
            status_t.setText("Setting Res Low");
        } else {
            if (cameraType == 7) {
                status_t.setText("Option not available");
                return;
            }
            this.res = 1;
            status_t.setText("Setting Res High");
        }
        mySerial.write("hr " + this.res);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n4 = as_c.getSelectedIndex() == 0 ? 0 : 1;
        mySerial.write("sm " + n4);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n5 = pd_c.getSelectedIndex() == 0 ? 0 : 1;
        mySerial.write("pd " + n5);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n6 = ti_c.getSelectedIndex() == 0 ? 0 : 1;
        mySerial.write("ti " + n6);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n7 = fs_c.getSelectedIndex() == 0 ? 0 : 1;
        mySerial.write("fs " + n7);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        int n8 = hd_c.getSelectedIndex() == 0 ? 0 : 1;
        mySerial.write("hd " + n8);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        mySerial.write("dc " + dc_c.getSelectedIndex());
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        if (bm_c.getSelectedIndex() == 0) {
            n = 0;
            status_t.setText("Setting buffer mode auto stream");
        } else {
            n = 1;
            status_t.setText("Setting buffer mode manual reload");
        }
        mySerial.write("bm " + n);
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        mySerial.write("nf " + nf_t.getText());
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        mySerial.write("ds " + dsx.getText() + " " + dsy.getText());
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        mySerial.write("vw " + x1.getText() + " " + y1.getText() + " " + x2.getText() + " " + y2.getText());
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        mySerial.write("sp " + pan_range_far.getText() + " " + pan_range_near.getText() + " " + pan_step.getText() + " " + tilt_range_far.getText() + " " + tilt_range_near.getText() + " " + tilt_step.getText());
        if (mySerial.readACK(1) != 1) {
            status_t.setText("Registers Failed.");
            return;
        }
        status_t.setText("Config Settings Sent");
    }

    private JCheckBoxMenuItem makeCheckMenuItem(String string, int n) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        if (n == 1) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(false);
        }
        jCheckBoxMenuItem.addItemListener(this);
        return jCheckBoxMenuItem;
    }
}

