/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CameraImage
extends JPanel
implements Serializable {
    boolean pickerStat;
    public int mm;
    int mmx;
    int mmy;
    int mmoldx;
    int mmoldy;
    char[][] bmask;
    int lm;
    int lmIndex;
    int tc;
    int width;
    int height;
    int[] pixels;
    int[] backup;
    int mx;
    int my;
    int xcoord;
    int ycoord;
    int zcoord;
    int oldz;
    int oldx;
    int oldy;
    int x2coord;
    int y2coord;
    int oldx2;
    int oldy2;
    int conf;
    MemoryImageSource source;
    BufferedImage image;
    JLabel red_l;
    JLabel green_l;
    JLabel blue_l;
    JPanel colorBox;
    int frames;
    int fps;
    long startTime;
    int start;
    int flipx = 0;
    int flipy = 0;
    long wdTimer;
    int scale;
    int[] rmin = new int[3];
    int[] rmax = new int[3];
    int[] gmin = new int[3];
    int[] gmax = new int[3];
    int[] bmin = new int[3];
    int[] bmax = new int[3];
    static int[] objDirt;
    int size_x;
    int size_y;
    int objnum = 0;
    int[] obj_x = new int[3];
    int[] obj_y = new int[3];
    int target_x = 0;
    int target_y = 0;
    double my_turn;
    double my_drive;
    JFrame channel_f;
    int cur_chan = 4;

    CameraImage(int n, int n2) {
        objDirt = new int[3];
        this.bmask = new char[10][48];
        this.my_drive = 0.0;
        this.lmIndex = 0;
        this.mmoldx = 0;
        this.mmoldy = 0;
        this.mmx = 0;
        this.mmy = 0;
        this.mm = 1;
        this.lm = 0;
        this.scale = 0;
        this.start = 1;
        this.zcoord = 0;
        this.xcoord = 0;
        this.ycoord = 0;
        this.x2coord = 0;
        this.y2coord = 0;
        this.oldx = 0;
        this.oldy = 0;
        this.oldx2 = 0;
        this.oldy2 = 0;
        this.oldz = 0;
        this.conf = 0;
        this.tc = 0;
        this.pickerStat = false;
        JPanel jPanel = new JPanel();
        this.red_l = new JLabel("0");
        this.green_l = new JLabel("0");
        this.blue_l = new JLabel("0");
        this.colorBox = new JPanel();
        this.colorBox.setPreferredSize(new Dimension(32, 32));
        GridLayout gridLayout = new GridLayout(2, 4);
        gridLayout.setHgap(5);
        jPanel.setLayout(gridLayout);
        jPanel.add(new JLabel());
        jPanel.add(new JLabel("Red"));
        jPanel.add(new JLabel("Green"));
        jPanel.add(new JLabel("Blue"));
        jPanel.add(new JLabel());
        jPanel.add(this.red_l);
        jPanel.add(this.green_l);
        jPanel.add(this.blue_l);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Color Picker"));
        jPanel2.add(this.colorBox);
        jPanel2.add(jPanel);
        MainWindow.status_t = new JTextField("starting up...");
        JPanel jPanel3 = new JPanel();
        GridLayout gridLayout2 = new GridLayout(2, 1);
        gridLayout2.setVgap(20);
        jPanel3.add(jPanel2);
        MainWindow.JPanel1.add(jPanel3);
        this.pickerStat = true;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.enableEvents(48L);
        this.setBackground(Color.black);
        this.width = n;
        this.height = n2;
        this.pixels = new int[this.width * this.height];
        this.backup = new int[this.width * this.height];
        this.image = new BufferedImage(this.width, this.height, 1);
        this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        this.frames = 0;
        this.fps = 0;
        Date date = new Date();
        this.startTime = date.getTime();
    }

    public void flip(int n) {
        int n2;
        int n3;
        if (n == 0) {
            for (n3 = 0; n3 < this.width; ++n3) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    this.backup[n2 * this.width + n3] = this.pixels[n2 * this.width + (this.width - n3 - 1)];
                }
            }
        } else {
            for (n3 = 0; n3 < this.width; ++n3) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    this.backup[n2 * this.width + n3] = this.pixels[(this.height - n2 - 1) * this.width + n3];
                }
            }
        }
        for (n3 = 0; n3 < this.width * this.height; ++n3) {
            this.pixels[n3] = this.backup[n3];
        }
        this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        this.repaint();
    }

    public void setChannel(int n) {
        int n2;
        if (this.cur_chan == 4) {
            for (n2 = 0; n2 < this.width * this.height; ++n2) {
                this.backup[n2] = this.pixels[n2];
            }
        }
        for (n2 = 0; n2 < this.width * this.height; ++n2) {
            int n3;
            int n4;
            this.cur_chan = n;
            if (n == 0) {
                n4 = this.backup[n2] & 0xFF0000;
                n3 = n4 | n4 >> 8 | n4 >> 16;
            } else if (n == 1) {
                n4 = this.backup[n2] & 0xFF00;
                n3 = n4 | n4 << 8 | n4 >> 8;
            } else if (n == 2) {
                n4 = this.backup[n2] & 0xFF;
                n3 = n4 | n4 << 8 | n4 << 16;
            } else {
                n3 = this.backup[n2];
            }
            Color color = new Color(n3);
            this.pixels[n2] = color.getRGB();
        }
        this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        this.repaint();
    }

    public void processEvent(AWTEvent aWTEvent) {
        this.mx = ((MouseEvent)aWTEvent).getX();
        this.my = ((MouseEvent)aWTEvent).getY();
        int n = this.mx - (this.getSize().width - this.width) / 2;
        int n2 = this.my - (this.getSize().height - this.height) / 2 - 20;
        if (this.size_x == 160 && this.size_y == 288) {
            n2 -= 72;
        }
        if (this.size_x == 320 && this.size_y == 288) {
            n2 -= 72;
        }
        int n3 = n < 0 || n2 < 0 || n > this.width - 1 || n2 > this.height - 1 ? 0 : this.pixels[n2 * this.width + n];
        Color color = new Color(n3);
        this.colorBox.setBackground(color);
        int n4 = n3 & 0xFF;
        this.blue_l.setText(String.valueOf(n4));
        int n5 = n3 >> 8 & 0xFF;
        this.green_l.setText(String.valueOf(n5));
        int n6 = n3 >> 16 & 0xFF;
        this.red_l.setText(String.valueOf(n6));
        int n7 = ((MouseEvent)aWTEvent).getButton();
        if (((MouseEvent)aWTEvent).getClickCount() > 0 && n7 != 0) {
            int n8;
            if (this.my_drive != 0.0) {
                // empty if block
            }
            if (n7 == 1) {
                CameraImage.objDirt[this.objnum] = 1;
                n8 = new Integer(MainWindow.tol_t.getText());
                this.rmin[this.objnum] = n6 - n8;
                if (this.rmin[this.objnum] < 0) {
                    this.rmin[this.objnum] = 0;
                }
                this.rmax[this.objnum] = n6 + n8;
                if (this.rmax[this.objnum] > 255) {
                    this.rmax[this.objnum] = 255;
                }
                this.gmin[this.objnum] = n5 - n8;
                if (this.gmin[this.objnum] < 0) {
                    this.gmin[this.objnum] = 0;
                }
                this.gmax[this.objnum] = n5 + n8;
                if (this.gmax[this.objnum] > 255) {
                    this.gmax[this.objnum] = 255;
                }
                this.bmin[this.objnum] = n4 - n8;
                if (this.bmin[this.objnum] < 0) {
                    this.bmin[this.objnum] = 0;
                }
                this.bmax[this.objnum] = n4 + n8;
                if (this.bmax[this.objnum] > 255) {
                    this.bmax[this.objnum] = 255;
                }
                MainWindow.rmin_t.setText(new Integer(this.rmin[this.objnum]).toString());
                MainWindow.gmin_t.setText(new Integer(this.gmin[this.objnum]).toString());
                MainWindow.bmin_t.setText(new Integer(this.bmin[this.objnum]).toString());
                MainWindow.rmax_t.setText(new Integer(this.rmax[this.objnum]).toString());
                MainWindow.gmax_t.setText(new Integer(this.gmax[this.objnum]).toString());
                MainWindow.bmax_t.setText(new Integer(this.bmax[this.objnum]).toString());
                int n9 = this.getSize().width;
                int n10 = this.getSize().height;
                int n11 = (n9 - this.width) / 2;
                int n12 = (n10 - this.height) / 2;
                this.obj_x[this.objnum] = this.mx - n11;
                this.obj_y[this.objnum] = this.my - n12;
            }
            if (objDirt[this.objnum] == 1) {
                n8 = this.obj_x[this.objnum];
                if (this.my_drive == 0.0) {
                    // empty if block
                }
            }
            this.repaint();
        }
    }

    public void sendFrame(int n) {
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < this.width * this.height; ++n2) {
            this.pixels[n2] = 0;
        }
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        if (MainWindow.fs_c.getSelectedIndex() != 1) {
            MainWindow.mySerial.readACK(0);
            if (MainWindow.cameraVersion == 1) {
                MainWindow.mySerial.write("df\r");
            } else if (n == 0) {
                MainWindow.mySerial.write("sf\r");
            } else {
                MainWindow.mySerial.write("sf " + (n - 1) + "\r");
            }
        }
        MainWindow.status_t.setText("Frame Grab...");
        while (true) {
            char c;
            if ((c = MainWindow.mySerial.getByte()) == '\u0000') {
                System.out.println("Data ==0");
                MainWindow.status_t.setText("Frame Grab Failed.");
                this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
                this.repaint();
                return;
            }
            if (c == '\u0001') {
                int n7;
                int n8;
                System.out.println("Got new Frame");
                bl = true;
                if (MainWindow.cameraVersion == 2) {
                    n8 = MainWindow.mySerial.getByte();
                    n7 = MainWindow.mySerial.getByte();
                    System.out.println("X size: " + n8 + " Y size: " + n7);
                    MainWindow.frameProg.setMaximum(n7 - 1);
                } else {
                    n8 = 80;
                    n7 = 144;
                    MainWindow.frameProg.setMaximum(80);
                }
                n2 = 0;
                n5 = 0;
                n6 = 0;
                continue;
            }
            if (c == '\u0002') {
                if (MainWindow.cameraVersion == 2) {
                    MainWindow.frameProg.setValue(n5);
                    System.out.println("Row " + n5 + " Width=" + n6);
                } else {
                    System.out.println("Rows: " + n5 + " Cols: " + n2);
                    MainWindow.frameProg.setValue(n2 / 2 + 1);
                }
                n6 = 0;
                if (MainWindow.cameraVersion == 1) {
                    n2 += 2;
                    n5 = 0;
                } else {
                    n2 = 0;
                    ++n5;
                }
                if (n5 > 288) {
                    n5 = 288;
                }
                if (n2 <= 352) continue;
                n2 = 352;
                continue;
            }
            if (c == '\u0003') {
                if (this.flipx == 1) {
                    this.flip(0);
                }
                if (this.flipy == 1) {
                    this.flip(1);
                }
                if (MainWindow.commandVal == 6) {
                    MainWindow.commandVal = 0;
                }
                this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
                this.repaint();
                MainWindow.status_t.setText("Frame Received");
                return;
            }
            if (!bl) continue;
            ++n6;
            char c2 = c;
            char c3 = '\u0000';
            char c4 = '\u0000';
            if (n == 0) {
                c3 = MainWindow.mySerial.getByte();
                c4 = MainWindow.mySerial.getByte();
            } else {
                c3 = c2;
                c4 = c2;
            }
            int n9 = 0;
            n9 += c4;
            n9 += c3 << 8;
            Color color = new Color(n9 += c2 << 16);
            if (MainWindow.cameraVersion == 1) {
                this.pixels[(n5 + n4) * this.width + n2 + n3] = color.getRGB();
                this.pixels[(n5 + n4) * this.width + n2 + n3 + 1] = color.getRGB();
                ++n5;
            } else {
                this.pixels[(n5 + n4) * this.width + n2 + n3] = color.getRGB();
                this.pixels[(n5 + n4) * this.width + ++n2 + n3] = color.getRGB();
                ++n2;
            }
            if (n5 > 288) {
                n5 = 288;
            }
            if (n2 <= 352) continue;
            n2 = 352;
        }
    }

    public boolean writeImage(String string) {
        boolean bl = false;
        ImageWriter imageWriter = null;
        Object var4_4 = null;
        System.out.println("Trying to write...");
        try {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("jpg");
            if (!iterator.hasNext()) {
                System.out.println("No readers for extension jpg");
                return false;
            }
            imageWriter = iterator.next();
            if (imageWriter == null) {
                System.out.println("No writers for extension jpg");
                return false;
            }
            File file = new File(string);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(1.0f);
            imageWriter.write(null, new IIOImage(this.image, null, null), imageWriteParam);
            System.out.println("File " + string + " written");
            bl = true;
            imageOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return true;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, n2);
        int n3 = (n - this.width) / 2;
        int n4 = (n2 - this.height) / 2 + 20;
        graphics.drawImage(this.image, n3, n4, this);
        for (int i = 0; i < 3; ++i) {
            if (objDirt[i] != 1) continue;
            if (i == 0) {
                graphics.setColor(Color.cyan);
            } else if (i == 1) {
                graphics.setColor(Color.green);
            } else if (i == 2) {
                graphics.setColor(Color.magenta);
            }
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    int n5 = this.pixels[j * this.width + k];
                    int n6 = n5 & 0xFF;
                    int n7 = n5 >> 8 & 0xFF;
                    int n8 = n5 >> 16 & 0xFF;
                    if (n8 >= this.rmax[i] || n8 <= this.rmin[i] || n7 >= this.gmax[i] || n7 <= this.gmin[i] || n6 >= this.bmax[i] || n6 <= this.bmin[i]) continue;
                    graphics.fillRect(k + n3, j + n4, 1, 1);
                }
            }
        }
    }
}

