import glob
import sys

# Track the persistence of a particular domain
persistence = {}

for fname in glob.glob("domains-data/{1}/*chr{0}.*.alpha*".format(sys.argv[1], sys.argv[2])):

    alpha = fname.split("=")[1][0:-3]

    if float(alpha) > float(sys.argv[3]):
        continue

    with open(fname) as f:
        for line in f:
            fields = line.rstrip().split()
            chrom, start, end, score = fields
            dom = (int(start), int(end))
            if dom not in persistence:
                persistence[dom] = 0
            persistence[dom] += 1

for dom, count in sorted(persistence.items(), key=lambda x: x[1]):
    print "\t".join(map(str, [dom[0], dom[1], count, sys.argv[1]]))
