import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class Main {

	public static int step = 20000;
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 3) {
			System.out.println("3 arguments required: path to 3C matrix file, step size (20000/40000/1000000), and alpha");
			System.exit(0);
		}
		String [] parts = args[0].split(File.separator);
		String filename = parts[parts.length - 1];
		System.out.println(filename);
		parts = filename.split("\\.");
		String chromo = parts[0];
		System.out.println(chromo);
		step = Integer.parseInt(args[1]);
		TreeMap<Integer, ArrayList<Edge3C>> data = parseGZIPDenseFile(args[0]);
		float alpha = Float.parseFloat(args[2]);

		for (Map.Entry<Integer, ArrayList<Edge3C>> pair : data.entrySet() ) {
//			System.err.println("Chromosome " + pair.getKey() + ". Got intra edges: " + pair.getValue().size());
			ArrayList<Edge3C> edges = pair.getValue();
			
			int N = 0;
			for (Edge3C e : edges) {
				if ( e.start1 > N)
					N = e.start1;
				if (e.start2 > N)
					N = e.start2;
				if (N > 13000)
					System.err.println(e.start1 + " " + e.start2);
			}
			
			// build matrix
			MyMTJMatrix m = new MyMTJMatrix(N+1);
			int e_cnt = 0;
			double sum = 0;
			int cnt = 0;
			for (Edge3C e : edges) {
				if (e.start1 <= e.start2) {// only do upper triangle
					e_cnt++;
					m.setElement(e.start1, e.start2, e.observed_cnt);
					if (e_cnt % 1000 == 0)
						m.compact();
					if (e.observed_cnt > 0) {
						sum+=e.observed_cnt;
						cnt++;
					}
				}
			}
			
//			BufferedWriter bf;
//			try {
//				bf = new BufferedWriter(new FileWriter(pair.getKey() + ".matrix"));
//				m.saveToFileAsCSVMatrix(bf, " ");
//				bf.close();
//			} catch (IOException e1) {
//				e1.printStackTrace();
//			}
		
			if (alpha > 0) {findDomainsAtAlpha(m, alpha, filename, chromo); }
			else {parameterSearch(m, filename, chromo); }
		}
	}
	
	private static void findDomainsAtAlpha(MyMTJMatrix m, float alpha, String name, String chromo) {
		FastHeirarchicalSubgraphFinder finder = new FastHeirarchicalSubgraphFinder();
		BufferedWriter bf;
		DecimalFormat df = new DecimalFormat("#.##");
		ArrayList<Interval> domains = finder.getCliquesRob(m, false, alpha);

		try {
			bf = new BufferedWriter(new FileWriter("domains." + name + ".alpha=" + df.format(alpha) + "txt" ) );

			for (Interval domain : domains) {
				bf.write(chromo + " " + domain.start * step + " " + domain.stop * step + " " + domain.score );
				bf.newLine();
			}
			bf.close();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		System.err.println("******************************");
	}
	
	/* not called from anywhere in this class; not visible outside of the class
	private static void findDomains(MyMTJMatrix m, double alpha, String filename, String chromo) {
		//FastDenseSubgraphFinder finder = new FastDenseSubgraphFinder();
		FastHeirarchicalSubgraphFinder finder = new FastHeirarchicalSubgraphFinder();
		BufferedWriter bf;
		System.err.println("Calculating optimal domains...");
		boolean filter = false;
		ArrayList<Clique> domains = finder.getCliques(m, filter, (float)alpha);
		System.err.println("Found " + domains.size() + " domains\nWriting to file...");
		try {
			String out_f_name = "domains." + filename;
			bf = new BufferedWriter(new FileWriter(out_f_name) );
			for (Clique c : domains) {
			 	ArrayList<Integer> indices = c.getIndices();
			 	Collections.sort(indices);
			 	bf.write(chromo + " " + indices.get(0) * step + " " + indices.get(indices.size() - 1) * step + " " + c.getQualityValue() );
			 	bf.newLine();
			 }
			bf.close();
			System.err.println("Domains saved to " + out_f_name);
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		System.err.println("******************************");
	}
	*/
	
	private static void parameterSearch(MyMTJMatrix m, String name, String chromo) {
		FastHeirarchicalSubgraphFinder finder = new FastHeirarchicalSubgraphFinder();
		float alpha;
		BufferedWriter bf;
		DecimalFormat df = new DecimalFormat("#.##");
		for (int i = 0; i < 20; i++) {
			alpha = (1.0f - 0.05f * i);
			System.err.println("Alpha = " + alpha);
			// ArrayList<Clique> domains = finder.getCliques(m, false, alpha);
			ArrayList<Interval> domains = finder.getCliquesRob(m, false, alpha);

			try {
				bf = new BufferedWriter(new FileWriter("domains." + name + ".alpha=" + df.format(alpha) + "txt" ) );

				for (Interval domain : domains) {
				 	bf.write(chromo + " " + domain.start * step + " " + domain.stop * step + " " + domain.score );
				 	bf.newLine();
				 }

				bf.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			System.err.println("******************************");
		}
	}
	
	private static TreeMap<Integer, ArrayList<Edge3C>> parseGZIPDenseFile(String path) {
		System.err.println("Parsing...");
		TreeMap<Integer, ArrayList<Edge3C>> chromo2intra = new TreeMap<Integer, ArrayList<Edge3C>>();
		int cnt = 0;
		GZIPInputStream zipReader = null;
		try {
			zipReader = new GZIPInputStream(new FileInputStream(path));
			InputStreamReader streamReader = new InputStreamReader(zipReader);
			BufferedReader br = new BufferedReader(streamReader);
			String line;
			Edge3C e;
			boolean firstLine =  false;
			float sum = 0;
			int edg_cnt = 0;
			while ( (line = br.readLine()) != null) {
				cnt++;
				if (cnt % 1000  == 0)
					System.out.print(cnt + " ");
				if (firstLine) {
					firstLine = false;
					continue;
				}
				String [] tokens = line.trim().split("\t");
				if (tokens.length > 12400)
					System.err.println(tokens.length);
				int start1 = Integer.parseInt(tokens[1]); // start
				
				for (int i = 3; i < tokens.length; i++) {
					float value = Float.parseFloat(tokens[i]); 
					if (value > 0.0) {
						edg_cnt++;
						int start2 = (i - 3);
						e = new Edge3C(start1 / step, start2, value);
						ArrayList<Edge3C> edges = chromo2intra.containsKey(e.chromo1) ? 
								chromo2intra.get(e.chromo1) : 
								chromo2intra.put(e.chromo1, new ArrayList<Edge3C>());
						edges = chromo2intra.get(e.chromo1);
						edges.add(e);
						sum+= value;
					}
				}
			}
			System.err.println("\nAvg edge " + (sum/edg_cnt)  + " sum " + sum + " cnt " + edg_cnt);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return chromo2intra;
	}

	private static TreeMap<Integer, ArrayList<Edge3C>> parseFile(String path) {
//		Set<Edge3C> edges = new TreeSet<Edge3C>();
		// organize by chromosome, only keep intra edges
		System.out.println("Parsing...");
		int cnt = 0;
		TreeMap<Integer, ArrayList<Edge3C>> chromo2intra = new TreeMap<Integer, ArrayList<Edge3C>>();
		try {
			BufferedReader br = new BufferedReader(new FileReader(path));
			String line;
			Edge3C e;
			// boolean firstLine =  false;
			while ( (line = br.readLine()) != null) {
				cnt++;
				if (cnt % 100000  == 0)
					System.out.println(cnt);
				// if (firstLine) {
				// 	firstLine = false;
				// 	continue;
				// }
				String [] tokens = line.trim().split("\t");
//				System.out.println(tokens);
//				System.out.println(tokens[1]);
				e = new Edge3C(tokens);
				if (e.chromo1 == e.chromo2) {
					ArrayList<Edge3C> edges = chromo2intra.containsKey(e.chromo1) ? 
							chromo2intra.get(e.chromo1) : 
							chromo2intra.put(e.chromo1, new ArrayList<Edge3C>());
					edges = chromo2intra.get(e.chromo1);
					edges.add(e);
				}
//				edges.add(e);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return chromo2intra;
	}

}
