// oct-conf.h.in
/*

Copyright (C) 1996, 1997, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
              2007, 2008, 2009 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>.

*/

#if !defined (octave_conf_h)
#define octave_conf_h 1

#ifndef OCTAVE_CONF_ALL_CFLAGS
#define OCTAVE_CONF_ALL_CFLAGS "-I. -I.. -I../liboctave -I../src -I../libcruft/misc  -DHAVE_CONFIG_H  -Wall -W -Wshadow -Wformat -O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic -pthread"
#endif

#ifndef OCTAVE_CONF_ALL_CXXFLAGS
#define OCTAVE_CONF_ALL_CXXFLAGS "-I. -I.. -I../liboctave -I../src -I../libcruft/misc  -DHAVE_CONFIG_H -I/usr/include/freetype2 -Wall -W -Wshadow -Wold-style-cast -Wformat -O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic -pthread"
#endif

#ifndef OCTAVE_CONF_ALL_FFLAGS
#define OCTAVE_CONF_ALL_FFLAGS "-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic -I/usr/lib64/gfortran/modules"
#endif

#ifndef OCTAVE_CONF_ALL_LDFLAGS
#define OCTAVE_CONF_ALL_LDFLAGS "-L..  -fPIC "
#endif

#ifndef OCTAVE_CONF_ARFLAGS
#define OCTAVE_CONF_ARFLAGS "rc "
#endif

#ifndef OCTAVE_CONF_AR
#define OCTAVE_CONF_AR "ar"
#endif

#ifndef OCTAVE_CONF_BLAS_LIBS
#define OCTAVE_CONF_BLAS_LIBS "-L/usr/lib64/atlas -llapack -L/usr/lib64/atlas -lf77blas -latlas"
#endif

#ifndef OCTAVE_CONF_CARBON_LIBS
#define OCTAVE_CONF_CARBON_LIBS ""
#endif

#ifndef OCTAVE_CONF_CC
#define OCTAVE_CONF_CC "gcc"
#endif

#ifndef OCTAVE_CONF_CC_VERSION
#define OCTAVE_CONF_CC_VERSION "4.4.3 20100211 (Red Hat 4.4.3-6) (GCC) "
#endif

#ifndef OCTAVE_CONF_CFLAGS
#define OCTAVE_CONF_CFLAGS "-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic"
#endif

#ifndef OCTAVE_CONF_CPICFLAG
#define OCTAVE_CONF_CPICFLAG "-fPIC"
#endif

#ifndef OCTAVE_CONF_CPPFLAGS
#define OCTAVE_CONF_CPPFLAGS "-DH5_USE_16_API "
#endif

#ifndef OCTAVE_CONF_CURL_LIBS
#define OCTAVE_CONF_CURL_LIBS "-lcurl"
#endif

#ifndef OCTAVE_CONF_CXXCPP
#define OCTAVE_CONF_CXXCPP "g++ -E"
#endif

#ifndef OCTAVE_CONF_CXXFLAGS
#define OCTAVE_CONF_CXXFLAGS "-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic"
#endif

#ifndef OCTAVE_CONF_CXXPICFLAG
#define OCTAVE_CONF_CXXPICFLAG "-fPIC"
#endif

#ifndef OCTAVE_CONF_CXX
#define OCTAVE_CONF_CXX "g++"
#endif

#ifndef OCTAVE_CONF_CXX_VERSION
#define OCTAVE_CONF_CXX_VERSION "4.4.3"
#endif

#ifndef OCTAVE_CONF_DEFAULT_PAGER
#define OCTAVE_CONF_DEFAULT_PAGER "less"
#endif

#ifndef OCTAVE_CONF_DEFS
#define OCTAVE_CONF_DEFS "-DPACKAGE_NAME=\"\" -DPACKAGE_TARNAME=\"\" -DPACKAGE_VERSION=\"\" -DPACKAGE_STRING=\"\" -DPACKAGE_BUGREPORT=\"\" -DPACKAGE_URL=\"\" -DOCTAVE_SOURCE=1 -DSTDC_HEADERS=1 -DHAVE_SYS_TYPES_H=1 -DHAVE_SYS_STAT_H=1 -DHAVE_STDLIB_H=1 -DHAVE_STRING_H=1 -DHAVE_MEMORY_H=1 -DHAVE_STRINGS_H=1 -DHAVE_INTTYPES_H=1 -DHAVE_STDINT_H=1 -DHAVE_UNISTD_H=1 -D__EXTENSIONS__=1 -D_ALL_SOURCE=1 -D_GNU_SOURCE=1 -D_POSIX_PTHREAD_SEMANTICS=1 -D_TANDEM_SOURCE=1 -DSEPCHAR=':' -DSEPCHAR_STR=\":\" -D__NO_MATH_INLINES=1 -DCXX_NEW_FRIEND_TEMPLATE_DECL=1 -DCXX_ISO_COMPLIANT_LIBRARY=1 -DHAVE_PTHREAD=1 -DHAVE_X_WINDOWS=1 -DHAVE_LIBM=1 -DHAVE_QHULL=1 -DHAVE_PCRE_COMPILE=1 -DHAVE_PCRE=1 -DHAVE_REGEXEC=1 -DHAVE_REGEX=1 -DHAVE_ZLIB_H=1 -DHAVE_ZLIB=1 -DHAVE_HDF5_H=1 -DHAVE_HDF5=1 -DHAVE_H5GGET_NUM_OBJS=1 -DHAVE_FFTW3=1 -DHAVE_GLPK_GLPK_H=1 -DHAVE_GLPK=1 -DHAVE_CURL_CURL_H=1 -DHAVE_CURL=1 -DHAVE_MAGICK=1 -DHAVE_GL_GL_H=1 -DHAVE_GL_GLU_H=1 -DHAVE_OPENGL=1 -DHAVE_FTGL_FTGL_H=1 -DHAVE_FTGL=1 -DHAVE_FLTK=1 -DHAVE_IEEE754_DATA_FORMAT=1 -DF77_FUNC(name,NAME)=name ## _ -DF77_FUNC_(name,NAME)=name ## _ -DHAVE_BLAS=1 -DHAVE_QRUPDATE=1 -DHAVE_SUITESPARSE_AMD_H=1 -DHAVE_AMD=1 -DHAVE_SUITESPARSE_UMFPACK_H=1 -DHAVE_UMFPACK=1 -DUMFPACK_SEPARATE_SPLIT=1 -DHAVE_SUITESPARSE_COLAMD_H=1 -DHAVE_COLAMD=1 -DHAVE_SUITESPARSE_CCOLAMD_H=1 -DHAVE_CCOLAMD=1 -DHAVE_SUITESPARSE_CHOLMOD_H=1 -DHAVE_CHOLMOD=1 -DHAVE_SUITESPARSE_CS_H=1 -DHAVE_CXSPARSE=1 -DHAVE_ARPACK=1 -DHAVE_GETHOSTNAME=1 -DHAVE_GETPWNAM=1 -DHAVE_DEV_T=1 -DHAVE_INO_T=1 -DHAVE_NLINK_T=1 -DHAVE_NLINK_T=1 -DHAVE_LONG_LONG_INT=1 -DHAVE_UNSIGNED_LONG_LONG_INT=1 -DHAVE_SIGSET_T=1 -DHAVE_SIG_ATOMIC_T=1 -DSIZEOF_SHORT=2 -DSIZEOF_INT=4 -DSIZEOF_LONG=8 -DSIZEOF_LONG_LONG=8 -DHAVE_ALLOCA_H=1 -DHAVE_ALLOCA=1 -DHAVE_PLACEMENT_DELETE=1 -DHAVE_DYNAMIC_AUTO_ARRAYS=1 -DHAVE_FAST_INT_OPS=1 -DSIZEOF_LONG_DOUBLE=16 -DSTDC_HEADERS=1 -DHAVE_DIRENT_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_SYS_WAIT_H=1 -DHAVE_ASSERT_H=1 -DHAVE_CURSES_H=1 -DHAVE_DLFCN_H=1 -DHAVE_FCNTL_H=1 -DHAVE_FLOAT_H=1 -DHAVE_GRP_H=1 -DHAVE_INTTYPES_H=1 -DHAVE_LIMITS_H=1 -DHAVE_LOCALE_H=1 -DHAVE_MEMORY_H=1 -DHAVE_NCURSES_H=1 -DHAVE_POLL_H=1 -DHAVE_PTHREAD_H=1 -DHAVE_PWD_H=1 -DHAVE_STDINT_H=1 -DHAVE_STDLIB_H=1 -DHAVE_STRING_H=1 -DHAVE_SYS_IOCTL_H=1 -DHAVE_SYS_PARAM_H=1 -DHAVE_SYS_POLL_H=1 -DHAVE_SYS_RESOURCE_H=1 -DHAVE_SYS_SELECT_H=1 -DHAVE_SYS_STAT_H=1 -DHAVE_SYS_TIME_H=1 -DHAVE_SYS_TIMES_H=1 -DHAVE_SYS_TYPES_H=1 -DHAVE_SYS_UTSNAME_H=1 -DHAVE_TERMCAP_H=1 -DHAVE_UNISTD_H=1 -DHAVE_UTIME_H=1 -DHAVE_SSTREAM=1 -DHAVE_TERMIOS_H=1 -DHAVE_TERMIO_H=1 -DHAVE_SGTTY_H=1 -DHAVE_GLOB_H=1 -DHAVE_FNMATCH_H=1 -DHAVE_FNMATCH=1 -DHAVE_GLOB=1 -DHAVE_ATEXIT=1 -DHAVE_BASENAME=1 -DHAVE_BCOPY=1 -DHAVE_BZERO=1 -DHAVE_CANONICALIZE_FILE_NAME=1 -DHAVE_CHMOD=1 -DHAVE_DUP2=1 -DHAVE_ENDGRENT=1 -DHAVE_ENDPWENT=1 -DHAVE_EXECVP=1 -DHAVE_EXPM1=1 -DHAVE_EXPM1F=1 -DHAVE_FCNTL=1 -DHAVE_FORK=1 -DHAVE_FSTAT=1 -DHAVE_GETCWD=1 -DHAVE_GETEGID=1 -DHAVE_GETEUID=1 -DHAVE_GETGID=1 -DHAVE_GETGRENT=1 -DHAVE_GETGRGID=1 -DHAVE_GETGRNAM=1 -DHAVE_GETPGRP=1 -DHAVE_GETPID=1 -DHAVE_GETPPID=1 -DHAVE_GETPWENT=1 -DHAVE_GETPWUID=1 -DHAVE_GETTIMEOFDAY=1 -DHAVE_GETUID=1 -DHAVE_GETWD=1 -DHAVE_KILL=1 -DHAVE_LGAMMA=1 -DHAVE_LGAMMAF=1 -DHAVE_LGAMMA_R=1 -DHAVE_LGAMMAF_R=1 -DHAVE_LINK=1 -DHAVE_LOCALTIME_R=1 -DHAVE_LOG1P=1 -DHAVE_LOG1PF=1 -DHAVE_LSTAT=1 -DHAVE_MEMMOVE=1 -DHAVE_MKDIR=1 -DHAVE_MKFIFO=1 -DHAVE_MKSTEMP=1 -DHAVE_ON_EXIT=1 -DHAVE_PIPE=1 -DHAVE_POLL=1 -DHAVE_PUTENV=1 -DHAVE_RAISE=1 -DHAVE_READLINK=1 -DHAVE_REALPATH=1 -DHAVE_RENAME=1 -DHAVE_RINDEX=1 -DHAVE_RMDIR=1 -DHAVE_ROUNDL=1 -DHAVE_SELECT=1 -DHAVE_SETGRENT=1 -DHAVE_SETLOCALE=1 -DHAVE_SETPWENT=1 -DHAVE_SETVBUF=1 -DHAVE_SIGACTION=1 -DHAVE_SIGLONGJMP=1 -DHAVE_SIGPENDING=1 -DHAVE_SIGPROCMASK=1 -DHAVE_SIGSUSPEND=1 -DHAVE_SNPRINTF=1 -DHAVE_STAT=1 -DHAVE_STRCASECMP=1 -DHAVE_STRDUP=1 -DHAVE_STRERROR=1 -DHAVE_STRNCASECMP=1 -DHAVE_STRPTIME=1 -DHAVE_STRSIGNAL=1 -DHAVE_SYMLINK=1 -DHAVE_TEMPNAM=1 -DHAVE_TGAMMAF=1 -DHAVE_TRUNC=1 -DHAVE_UMASK=1 -DHAVE_UNAME=1 -DHAVE_UNLINK=1 -DHAVE_USLEEP=1 -DHAVE_UTIME=1 -DHAVE_VFPRINTF=1 -DHAVE_VSPRINTF=1 -DHAVE_VSNPRINTF=1 -DHAVE_WAITPID=1 -DHAVE_DECL_EXP2=1 -DHAVE_DECL_ROUND=1 -DHAVE_DECL_TGAMMA=1 -DHAVE_EXP2=1 -DHAVE_ROUND=1 -DHAVE_TGAMMA=1 -DHAVE_STRFTIME=1 -DHAVE_C99_VSNPRINTF=1 -DHAVE_LIBDL=1 -DHAVE_DLOPEN=1 -DHAVE_DLSYM=1 -DHAVE_DLERROR=1 -DHAVE_DLCLOSE=1 -DHAVE_DLOPEN_API=1 -DENABLE_DYNAMIC_LINKING=1 -DHAVE_TIMEVAL=1 -DHAVE_CMATH_ISNAN=1 -DHAVE_CMATH_ISNANF=1 -DHAVE_CMATH_ISINF=1 -DHAVE_CMATH_ISINFF=1 -DHAVE_CMATH_ISFINITE=1 -DHAVE_CMATH_ISFINITEF=1 -DHAVE_FINITE=1 -DHAVE_ISNAN=1 -DHAVE_ISINF=1 -DHAVE_COPYSIGN=1 -DHAVE_DECL_SIGNBIT=1 -DHAVE_ACOSH=1 -DHAVE_ACOSHF=1 -DHAVE_ASINH=1 -DHAVE_ASINHF=1 -DHAVE_ATANH=1 -DHAVE_ATANHF=1 -DHAVE_ERF=1 -DHAVE_ERFF=1 -DHAVE_ERFC=1 -DHAVE_ERFCF=1 -DHAVE_EXP2F=1 -DHAVE_LOG2=1 -DHAVE_LOG2F=1 -DHAVE_HYPOTF=1 -DHAVE_STRUCT_STAT_ST_BLKSIZE=1 -DHAVE_STRUCT_STAT_ST_BLOCKS=1 -DHAVE_STRUCT_STAT_ST_RDEV=1 -DHAVE_STRUCT_TM_TM_ZONE=1 -DHAVE_TM_ZONE=1 -DUSE_READLINE=1 -DEXCEPTION_IN_MATH=1 -DRETSIGTYPE=void -DHAVE_DECL_SYS_SIGLIST=1 -DHAVE_POSIX_SIGNALS=1 -DRETSIGTYPE_IS_VOID=1 -DHAVE_GETRUSAGE=1 -DHAVE_TIMES=1 -DYYTEXT_POINTER=1"
#endif

#ifndef OCTAVE_CONF_DL_LD
#define OCTAVE_CONF_DL_LD "g++"
#endif

#ifndef OCTAVE_CONF_DL_LDFLAGS
#define OCTAVE_CONF_DL_LDFLAGS "-shared"
#endif

#ifndef OCTAVE_CONF_EXEEXT
#define OCTAVE_CONF_EXEEXT ""
#endif

#ifndef OCTAVE_CONF_F77
#define OCTAVE_CONF_F77 "gfortran"
#endif

#ifndef OCTAVE_CONF_F77_FLOAT_STORE_FLAG
#define OCTAVE_CONF_F77_FLOAT_STORE_FLAG "-ffloat-store"
#endif

#ifndef OCTAVE_CONF_FC
#define OCTAVE_CONF_FC "gfortran"
#endif

#ifndef OCTAVE_CONF_FFLAGS
#define OCTAVE_CONF_FFLAGS "-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic -I/usr/lib64/gfortran/modules"
#endif

#ifndef OCTAVE_CONF_FFTW_LIBS
#define OCTAVE_CONF_FFTW_LIBS "-lfftw3 -lfftw3f"
#endif

#ifndef OCTAVE_CONF_FLIBS
#define OCTAVE_CONF_FLIBS "-L/usr/lib/gcc/x86_64-redhat-linux/4.4.3 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.3/../../../../lib64 -L/lib/../lib64 -L/usr/lib/../lib64 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.3/../../.. -lhdf5 -lz -lgfortranbegin -lgfortran -lm"
#endif

#ifndef OCTAVE_CONF_FPICFLAG
#define OCTAVE_CONF_FPICFLAG "-fPIC"
#endif

#ifndef OCTAVE_CONF_GLPK_LIBS
#define OCTAVE_CONF_GLPK_LIBS "-lglpk"
#endif

#ifndef OCTAVE_CONF_GNUPLOT
#define OCTAVE_CONF_GNUPLOT "gnuplot"
#endif

#ifndef OCTAVE_CONF_INCFLAGS
#define OCTAVE_CONF_INCFLAGS "-I. -I.. -I../liboctave -I../src -I../libcruft/misc"
#endif

#ifndef OCTAVE_CONF_INCLUDEDIR
#define OCTAVE_CONF_INCLUDEDIR "/usr/include"
#endif

#ifndef OCTAVE_CONF_LDFLAGS
#define OCTAVE_CONF_LDFLAGS ""
#endif

#ifndef OCTAVE_CONF_LD_CXX
#define OCTAVE_CONF_LD_CXX "g++"
#endif

#ifndef OCTAVE_CONF_LD_STATIC_FLAG
#define OCTAVE_CONF_LD_STATIC_FLAG ""
#endif

#ifndef OCTAVE_CONF_LEXLIB
#define OCTAVE_CONF_LEXLIB ""
#endif

#ifndef OCTAVE_CONF_LEX
#define OCTAVE_CONF_LEX "flex"
#endif

#ifndef OCTAVE_CONF_LFLAGS
#define OCTAVE_CONF_LFLAGS "-t -I"
#endif

#ifndef OCTAVE_CONF_LIBCRUFT
#define OCTAVE_CONF_LIBCRUFT "-lcruft"
#endif

#ifndef OCTAVE_CONF_LIBEXT
#define OCTAVE_CONF_LIBEXT "a"
#endif

#ifndef OCTAVE_CONF_LIBFLAGS
#define OCTAVE_CONF_LIBFLAGS "-L.."
#endif

#ifndef OCTAVE_CONF_LIBOCTAVE
#define OCTAVE_CONF_LIBOCTAVE "-loctave"
#endif

#ifndef OCTAVE_CONF_LIBOCTINTERP
#define OCTAVE_CONF_LIBOCTINTERP "-loctinterp"
#endif

#ifndef OCTAVE_CONF_LIBPLPLOT
#define OCTAVE_CONF_LIBPLPLOT %OCTAVE_CONF_LIBPLPLOT%
#endif

#ifndef OCTAVE_CONF_LIBREADLINE
#define OCTAVE_CONF_LIBREADLINE "-lreadline"
#endif

#ifndef OCTAVE_CONF_LIBS
#define OCTAVE_CONF_LIBS "-lreadline  -lncurses -ldl -lhdf5 -lz -lm "
#endif

#ifndef OCTAVE_CONF_LN_S
#define OCTAVE_CONF_LN_S "ln -s"
#endif

#ifndef OCTAVE_CONF_MAGICK_INCFLAGS
#define OCTAVE_CONF_MAGICK_INCFLAGS "-I/usr/include/GraphicsMagick"
#endif

#ifndef OCTAVE_CONF_MAGICK_LIBS
#define OCTAVE_CONF_MAGICK_LIBS "-lGraphicsMagick++ -lGraphicsMagick -llcms -lfreetype -lXext -lSM -lICE -lX11 -lbz2 -lz -lm -lgomp -lpthread "
#endif

#ifndef OCTAVE_CONF_MKOCTFILE_DL_LDFLAGS
#define OCTAVE_CONF_MKOCTFILE_DL_LDFLAGS "-shared -Wl,-Bsymbolic"
#endif

#ifndef OCTAVE_CONF_OCTINCLUDEDIR
#define OCTAVE_CONF_OCTINCLUDEDIR "/usr/include/octave-3.2.4"
#endif

#ifndef OCTAVE_CONF_OCTLIBDIR
#define OCTAVE_CONF_OCTLIBDIR "/usr/lib64/octave-3.2.4"
#endif

#ifndef OCTAVE_CONF_PREFIX
#define OCTAVE_CONF_PREFIX "/usr"
#endif

#ifndef OCTAVE_CONF_RANLIB
#define OCTAVE_CONF_RANLIB "ranlib"
#endif

#ifndef OCTAVE_CONF_RDYNAMIC_FLAG
#define OCTAVE_CONF_RDYNAMIC_FLAG "-rdynamic"
#endif

#ifndef OCTAVE_CONF_RLD_FLAG
#define OCTAVE_CONF_RLD_FLAG "-Wl,-rpath -Wl,/usr/lib64/octave-3.2.4"
#endif

#ifndef OCTAVE_CONF_SED
#define OCTAVE_CONF_SED "/bin/sed"
#endif

#ifndef OCTAVE_CONF_SHARED_LIBS
#define OCTAVE_CONF_SHARED_LIBS "true"
#endif

#ifndef OCTAVE_CONF_SHLEXT
#define OCTAVE_CONF_SHLEXT "so"
#endif

#ifndef OCTAVE_CONF_SHLEXT_VER
#define OCTAVE_CONF_SHLEXT_VER "so.3.2.4"
#endif

#ifndef OCTAVE_CONF_SH_LD
#define OCTAVE_CONF_SH_LD "g++"
#endif

#ifndef OCTAVE_CONF_SH_LDFLAGS
#define OCTAVE_CONF_SH_LDFLAGS "-shared"
#endif

#ifndef OCTAVE_CONF_SONAME_FLAGS
#define OCTAVE_CONF_SONAME_FLAGS "-Wl,-soname -Wl,oct-conf.h"
#endif

#ifndef OCTAVE_CONF_STATIC_LIBS
#define OCTAVE_CONF_STATIC_LIBS "false"
#endif

#ifndef OCTAVE_CONF_UGLY_DEFS
#define OCTAVE_CONF_UGLY_DEFS "-DPACKAGE_NAME=\"\" -DPACKAGE_TARNAME=\"\" -DPACKAGE_VERSION=\"\" -DPACKAGE_STRING=\"\" -DPACKAGE_BUGREPORT=\"\" -DPACKAGE_URL=\"\" -DOCTAVE_SOURCE=1 -DSTDC_HEADERS=1 -DHAVE_SYS_TYPES_H=1 -DHAVE_SYS_STAT_H=1 -DHAVE_STDLIB_H=1 -DHAVE_STRING_H=1 -DHAVE_MEMORY_H=1 -DHAVE_STRINGS_H=1 -DHAVE_INTTYPES_H=1 -DHAVE_STDINT_H=1 -DHAVE_UNISTD_H=1 -D__EXTENSIONS__=1 -D_ALL_SOURCE=1 -D_GNU_SOURCE=1 -D_POSIX_PTHREAD_SEMANTICS=1 -D_TANDEM_SOURCE=1 -DSEPCHAR=':' -DSEPCHAR_STR=\":\" -D__NO_MATH_INLINES=1 -DCXX_NEW_FRIEND_TEMPLATE_DECL=1 -DCXX_ISO_COMPLIANT_LIBRARY=1 -DHAVE_PTHREAD=1 -DHAVE_X_WINDOWS=1 -DHAVE_LIBM=1 -DHAVE_QHULL=1 -DHAVE_PCRE_COMPILE=1 -DHAVE_PCRE=1 -DHAVE_REGEXEC=1 -DHAVE_REGEX=1 -DHAVE_ZLIB_H=1 -DHAVE_ZLIB=1 -DHAVE_HDF5_H=1 -DHAVE_HDF5=1 -DHAVE_H5GGET_NUM_OBJS=1 -DHAVE_FFTW3=1 -DHAVE_GLPK_GLPK_H=1 -DHAVE_GLPK=1 -DHAVE_CURL_CURL_H=1 -DHAVE_CURL=1 -DHAVE_MAGICK=1 -DHAVE_GL_GL_H=1 -DHAVE_GL_GLU_H=1 -DHAVE_OPENGL=1 -DHAVE_FTGL_FTGL_H=1 -DHAVE_FTGL=1 -DHAVE_FLTK=1 -DHAVE_IEEE754_DATA_FORMAT=1 -DF77_FUNC(name,NAME)=name ## _ -DF77_FUNC_(name,NAME)=name ## _ -DHAVE_BLAS=1 -DHAVE_QRUPDATE=1 -DHAVE_SUITESPARSE_AMD_H=1 -DHAVE_AMD=1 -DHAVE_SUITESPARSE_UMFPACK_H=1 -DHAVE_UMFPACK=1 -DUMFPACK_SEPARATE_SPLIT=1 -DHAVE_SUITESPARSE_COLAMD_H=1 -DHAVE_COLAMD=1 -DHAVE_SUITESPARSE_CCOLAMD_H=1 -DHAVE_CCOLAMD=1 -DHAVE_SUITESPARSE_CHOLMOD_H=1 -DHAVE_CHOLMOD=1 -DHAVE_SUITESPARSE_CS_H=1 -DHAVE_CXSPARSE=1 -DHAVE_ARPACK=1 -DHAVE_GETHOSTNAME=1 -DHAVE_GETPWNAM=1 -DHAVE_DEV_T=1 -DHAVE_INO_T=1 -DHAVE_NLINK_T=1 -DHAVE_NLINK_T=1 -DHAVE_LONG_LONG_INT=1 -DHAVE_UNSIGNED_LONG_LONG_INT=1 -DHAVE_SIGSET_T=1 -DHAVE_SIG_ATOMIC_T=1 -DSIZEOF_SHORT=2 -DSIZEOF_INT=4 -DSIZEOF_LONG=8 -DSIZEOF_LONG_LONG=8 -DHAVE_ALLOCA_H=1 -DHAVE_ALLOCA=1 -DHAVE_PLACEMENT_DELETE=1 -DHAVE_DYNAMIC_AUTO_ARRAYS=1 -DHAVE_FAST_INT_OPS=1 -DSIZEOF_LONG_DOUBLE=16 -DSTDC_HEADERS=1 -DHAVE_DIRENT_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_SYS_WAIT_H=1 -DHAVE_ASSERT_H=1 -DHAVE_CURSES_H=1 -DHAVE_DLFCN_H=1 -DHAVE_FCNTL_H=1 -DHAVE_FLOAT_H=1 -DHAVE_GRP_H=1 -DHAVE_INTTYPES_H=1 -DHAVE_LIMITS_H=1 -DHAVE_LOCALE_H=1 -DHAVE_MEMORY_H=1 -DHAVE_NCURSES_H=1 -DHAVE_POLL_H=1 -DHAVE_PTHREAD_H=1 -DHAVE_PWD_H=1 -DHAVE_STDINT_H=1 -DHAVE_STDLIB_H=1 -DHAVE_STRING_H=1 -DHAVE_SYS_IOCTL_H=1 -DHAVE_SYS_PARAM_H=1 -DHAVE_SYS_POLL_H=1 -DHAVE_SYS_RESOURCE_H=1 -DHAVE_SYS_SELECT_H=1 -DHAVE_SYS_STAT_H=1 -DHAVE_SYS_TIME_H=1 -DHAVE_SYS_TIMES_H=1 -DHAVE_SYS_TYPES_H=1 -DHAVE_SYS_UTSNAME_H=1 -DHAVE_TERMCAP_H=1 -DHAVE_UNISTD_H=1 -DHAVE_UTIME_H=1 -DHAVE_SSTREAM=1 -DHAVE_TERMIOS_H=1 -DHAVE_TERMIO_H=1 -DHAVE_SGTTY_H=1 -DHAVE_GLOB_H=1 -DHAVE_FNMATCH_H=1 -DHAVE_FNMATCH=1 -DHAVE_GLOB=1 -DHAVE_ATEXIT=1 -DHAVE_BASENAME=1 -DHAVE_BCOPY=1 -DHAVE_BZERO=1 -DHAVE_CANONICALIZE_FILE_NAME=1 -DHAVE_CHMOD=1 -DHAVE_DUP2=1 -DHAVE_ENDGRENT=1 -DHAVE_ENDPWENT=1 -DHAVE_EXECVP=1 -DHAVE_EXPM1=1 -DHAVE_EXPM1F=1 -DHAVE_FCNTL=1 -DHAVE_FORK=1 -DHAVE_FSTAT=1 -DHAVE_GETCWD=1 -DHAVE_GETEGID=1 -DHAVE_GETEUID=1 -DHAVE_GETGID=1 -DHAVE_GETGRENT=1 -DHAVE_GETGRGID=1 -DHAVE_GETGRNAM=1 -DHAVE_GETPGRP=1 -DHAVE_GETPID=1 -DHAVE_GETPPID=1 -DHAVE_GETPWENT=1 -DHAVE_GETPWUID=1 -DHAVE_GETTIMEOFDAY=1 -DHAVE_GETUID=1 -DHAVE_GETWD=1 -DHAVE_KILL=1 -DHAVE_LGAMMA=1 -DHAVE_LGAMMAF=1 -DHAVE_LGAMMA_R=1 -DHAVE_LGAMMAF_R=1 -DHAVE_LINK=1 -DHAVE_LOCALTIME_R=1 -DHAVE_LOG1P=1 -DHAVE_LOG1PF=1 -DHAVE_LSTAT=1 -DHAVE_MEMMOVE=1 -DHAVE_MKDIR=1 -DHAVE_MKFIFO=1 -DHAVE_MKSTEMP=1 -DHAVE_ON_EXIT=1 -DHAVE_PIPE=1 -DHAVE_POLL=1 -DHAVE_PUTENV=1 -DHAVE_RAISE=1 -DHAVE_READLINK=1 -DHAVE_REALPATH=1 -DHAVE_RENAME=1 -DHAVE_RINDEX=1 -DHAVE_RMDIR=1 -DHAVE_ROUNDL=1 -DHAVE_SELECT=1 -DHAVE_SETGRENT=1 -DHAVE_SETLOCALE=1 -DHAVE_SETPWENT=1 -DHAVE_SETVBUF=1 -DHAVE_SIGACTION=1 -DHAVE_SIGLONGJMP=1 -DHAVE_SIGPENDING=1 -DHAVE_SIGPROCMASK=1 -DHAVE_SIGSUSPEND=1 -DHAVE_SNPRINTF=1 -DHAVE_STAT=1 -DHAVE_STRCASECMP=1 -DHAVE_STRDUP=1 -DHAVE_STRERROR=1 -DHAVE_STRNCASECMP=1 -DHAVE_STRPTIME=1 -DHAVE_STRSIGNAL=1 -DHAVE_SYMLINK=1 -DHAVE_TEMPNAM=1 -DHAVE_TGAMMAF=1 -DHAVE_TRUNC=1 -DHAVE_UMASK=1 -DHAVE_UNAME=1 -DHAVE_UNLINK=1 -DHAVE_USLEEP=1 -DHAVE_UTIME=1 -DHAVE_VFPRINTF=1 -DHAVE_VSPRINTF=1 -DHAVE_VSNPRINTF=1 -DHAVE_WAITPID=1 -DHAVE_DECL_EXP2=1 -DHAVE_DECL_ROUND=1 -DHAVE_DECL_TGAMMA=1 -DHAVE_EXP2=1 -DHAVE_ROUND=1 -DHAVE_TGAMMA=1 -DHAVE_STRFTIME=1 -DHAVE_C99_VSNPRINTF=1 -DHAVE_LIBDL=1 -DHAVE_DLOPEN=1 -DHAVE_DLSYM=1 -DHAVE_DLERROR=1 -DHAVE_DLCLOSE=1 -DHAVE_DLOPEN_API=1 -DENABLE_DYNAMIC_LINKING=1 -DHAVE_TIMEVAL=1 -DHAVE_CMATH_ISNAN=1 -DHAVE_CMATH_ISNANF=1 -DHAVE_CMATH_ISINF=1 -DHAVE_CMATH_ISINFF=1 -DHAVE_CMATH_ISFINITE=1 -DHAVE_CMATH_ISFINITEF=1 -DHAVE_FINITE=1 -DHAVE_ISNAN=1 -DHAVE_ISINF=1 -DHAVE_COPYSIGN=1 -DHAVE_DECL_SIGNBIT=1 -DHAVE_ACOSH=1 -DHAVE_ACOSHF=1 -DHAVE_ASINH=1 -DHAVE_ASINHF=1 -DHAVE_ATANH=1 -DHAVE_ATANHF=1 -DHAVE_ERF=1 -DHAVE_ERFF=1 -DHAVE_ERFC=1 -DHAVE_ERFCF=1 -DHAVE_EXP2F=1 -DHAVE_LOG2=1 -DHAVE_LOG2F=1 -DHAVE_HYPOTF=1 -DHAVE_STRUCT_STAT_ST_BLKSIZE=1 -DHAVE_STRUCT_STAT_ST_BLOCKS=1 -DHAVE_STRUCT_STAT_ST_RDEV=1 -DHAVE_STRUCT_TM_TM_ZONE=1 -DHAVE_TM_ZONE=1 -DUSE_READLINE=1 -DEXCEPTION_IN_MATH=1 -DRETSIGTYPE=void -DHAVE_DECL_SYS_SIGLIST=1 -DHAVE_POSIX_SIGNALS=1 -DRETSIGTYPE_IS_VOID=1 -DHAVE_GETRUSAGE=1 -DHAVE_TIMES=1 -DYYTEXT_POINTER=1"
#endif

#ifndef OCTAVE_CONF_USE_64_BIT_IDX_T
#define OCTAVE_CONF_USE_64_BIT_IDX_T "false"
#endif

#ifndef OCTAVE_CONF_ENABLE_DYNAMIC_LINKING
#define OCTAVE_CONF_ENABLE_DYNAMIC_LINKING "true"
#endif

#ifndef OCTAVE_CONF_X11_INCFLAGS
#define OCTAVE_CONF_X11_INCFLAGS ""
#endif

#ifndef OCTAVE_CONF_X11_LIBS
#define OCTAVE_CONF_X11_LIBS "-lX11"
#endif

#ifndef OCTAVE_CONF_XTRA_CFLAGS
#define OCTAVE_CONF_XTRA_CFLAGS ""
#endif

#ifndef OCTAVE_CONF_XTRA_CXXFLAGS
#define OCTAVE_CONF_XTRA_CXXFLAGS "-I/usr/include/freetype2"
#endif

#ifndef OCTAVE_CONF_YACC
#define OCTAVE_CONF_YACC "bison -y"
#endif

#ifndef OCTAVE_CONF_YFLAGS
#define OCTAVE_CONF_YFLAGS "-dv"
#endif

#ifndef OCTAVE_CONF_config_opts
#define OCTAVE_CONF_config_opts "'--build=x86_64-redhat-linux-gnu' '--host=x86_64-redhat-linux-gnu' '--program-prefix=' '--disable-dependency-tracking' '--prefix=/usr' '--exec-prefix=/usr' '--bindir=/usr/bin' '--sbindir=/usr/sbin' '--sysconfdir=/etc' '--datadir=/usr/share' '--includedir=/usr/include' '--libdir=/usr/lib64' '--libexecdir=/usr/libexec' '--localstatedir=/var' '--sharedstatedir=/var/lib' '--mandir=/usr/share/man' '--infodir=/usr/share/info' '--enable-shared' '--disable-static' '--enable-64=no' '--with-blas=-L/usr/lib64/atlas -lf77blas -latlas' '--with-qrupdate' '--with-lapack=-L/usr/lib64/atlas -llapack' '--with-amd' '--with-umfpack' '--with-colamd' '--with-ccolamd' '--with-cholmod' '--with-cxsparse' '--with-arpack' 'build_alias=x86_64-redhat-linux-gnu' 'host_alias=x86_64-redhat-linux-gnu' 'CFLAGS=-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic' 'CPPFLAGS=-DH5_USE_16_API' 'CXXFLAGS=-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic' 'F77=gfortran' 'FFLAGS=-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -m64 -mtune=generic -I/usr/lib64/gfortran/modules'"
#endif

#endif

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; page-delimiter: "^/\\*" ***
;;; End: ***
*/
