/*****************************************************************************
**
**  util.h
**	
**	  utility class for Role Project.
**	
**	  it can contain all kinds of utility
**
**  Currently
** 
**	matrix multiply & inverse for 4x4 matrix
**  absolute, max,min, and rotation functions
**  Also collision table class.
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef util_header
#define util_header

#include "types.h"

//extern RoleFLOAT max(RoleFLOAT x, RoleFLOAT y);

extern void rolePrintlog(char *format, ...);	// Debug Messages.
extern void quit_role (int code);

extern RoleFLOAT inline absolute(RoleFLOAT a);
extern RoleFLOAT inline maxFloat(RoleFLOAT a,RoleFLOAT b);
extern RoleFLOAT inline minFloat(RoleFLOAT a,RoleFLOAT b);
extern void inline crossProduct3f(RoleFLOAT first[3], RoleFLOAT second[3],RoleFLOAT result[3]);
extern void inline crossProduct3f(RoleFLOAT ax, RoleFLOAT ay, RoleFLOAT az,
					RoleFLOAT bx, RoleFLOAT by, RoleFLOAT bz,
					RoleFLOAT result[3]);
extern RoleFLOAT inline dotProduct3f(RoleFLOAT first[3], RoleFLOAT second[3]);
extern RoleFLOAT inline dotProduct3f(RoleFLOAT first[3], RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz);
extern void inline matrixMultiply4by4(RoleFLOAT first[16], RoleFLOAT second[16], RoleFLOAT result[16]);
extern RoleBOOL inline inverse(RoleFLOAT matrix[16]);
extern void inline rotateCoord(int dir,RoleFLOAT angle, RoleFLOAT cx, RoleFLOAT cy, RoleFLOAT cz,
					RoleFLOAT * dstx,RoleFLOAT * dsty,RoleFLOAT * dstz);
extern void inline rotateCoordOnXZ(RoleFLOAT axis[3],RoleFLOAT angle, RoleFLOAT cx,RoleFLOAT cy, RoleFLOAT cz,
						RoleFLOAT * dstx,RoleFLOAT * dsty,RoleFLOAT * dstz);
extern char * ipaddress;
extern int numplayer;
extern int multitexture;

/*---------------------------------------------------------------------//

   RoleCollisionTable class (2D)
	
//---------------------------------------------------------------------*/

class Object;
class Area;

class RoleCollisionTable
{
	
public:

	RoleCollisionTable(Area * a);
	~RoleCollisionTable();
	RoleBOOL addObject(Object * o);
	RoleBOOL addObject(Object * o,RoleFLOAT x,RoleFLOAT y,RoleFLOAT z);
	RoleBOOL removeObject(Object * o);
	RoleBOOL moveObject(Object * o,RoleFLOAT x,RoleFLOAT y,RoleFLOAT z);
	vector<Object *> *	getCellObjlist(RoleINT x,RoleINT z);

private:
	RoleINT sizeX;
	RoleINT sizeY;

	vector<Object *> * table;
};


#endif
