/*****************************************************************************
**
**	  util.cpp
**	
**	  utility class for Role Project.
**	
**	  it can contain all kinds of utility
**
**		see header file 'util.h'
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/


#include "util.h"
#include "types.h"
#include "player.h"
#include "object.h"
#include "area.h"
#include "sdl.h"

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

#include "audio.h"

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //


FILE * logfile = NULL;

extern Area * world;
extern Player * player;
extern char * ipaddress = NULL;
extern int numplayer = 1;
extern int multitexture = 0;

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

extern BackgroundMusic * bgmusic;

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

// writing to log file. txt format.
void rolePrintlog(char *format, ...)	// Debug Messages.
{
    va_list args;
	va_start(args, format);
	vfprintf(logfile, format, args);
	va_end(args);
}

// quit engine. always use this instead of exit(0).

void quit_role (int code)
{
	Uint32 quittime = SDL_GetTicks();
	delete world;
	delete player;

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

//	delete bgmusic;

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	rolePrintlog("\nYou have played %i minutes %i seconds \n",
		quittime/60000, quittime%60000/1000);
	rolePrintlog("\nRole engine log ends\n");
    fclose(logfile);
	SDL_Quit();
	exit(EXIT_SUCCESS);
}


RoleFLOAT inline absolute(RoleFLOAT a)
{
	if (a < 0 )
		return -a;
	else
		return a;
}

RoleFLOAT inline maxFloat(RoleFLOAT a,RoleFLOAT b)
{
	if (a < b )
		return b;
	else
		return a;
}

RoleFLOAT inline minFloat(RoleFLOAT a,RoleFLOAT b)
{
	if (a > b )
		return b;
	else
		return a;
}

void inline crossProduct3f(RoleFLOAT first[3], RoleFLOAT second[3],RoleFLOAT result[3])
{
	result[0] = first[1]*second[2]-first[2]*second[1];
	result[1] = first[2]*second[0]-first[0]*second[2];
	result[2] = first[0]*second[1]-first[1]*second[0];
	RoleFLOAT length = sqrt(result[0]*result[0]+
		result[1]*result[1]+result[2]*result[2]);
	result[0] /= length;
	result[1] /= length;
	result[2] /= length;
}

void inline crossProduct3f(RoleFLOAT ax, RoleFLOAT ay, RoleFLOAT az,
					RoleFLOAT bx, RoleFLOAT by, RoleFLOAT bz,
					RoleFLOAT result[3])
{
	result[0] = ay*bz-az*by;
	result[1] = az*bx-ax*bz;
	result[2] = ax*by-ay*bx;
	RoleFLOAT length = sqrt(result[0]*result[0]+
		result[1]*result[1]+result[2]*result[2]);
	result[0] /= length;
	result[1] /= length;
	result[2] /= length;
}


RoleFLOAT inline dotProduct3f(RoleFLOAT first[3], RoleFLOAT second[3])
{
	return first[0]*second[0]+first[1]*second[1]+first[2]*second[2];
}

RoleFLOAT inline dotProduct3f(RoleFLOAT first[3], RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz)
{
	return first[0]*sx+first[1]*sy+first[2]*sz;
}

// taken from  Nate Miller's program. nkmiller@calpoly.edu
// he has taken from SGI's sample GL implementation, should work 
void inline matrixMultiply4by4(RoleFLOAT first[16], RoleFLOAT second[16], RoleFLOAT result[16])
{
	result[ 0] = second[ 0] * first[ 0] + second[ 1] * first[ 4] + second[ 2] * first[ 8] + second[ 3] * first[12];
	result[ 1] = second[ 0] * first[ 1] + second[ 1] * first[ 5] + second[ 2] * first[ 9] + second[ 3] * first[13];
	result[ 2] = second[ 0] * first[ 2] + second[ 1] * first[ 6] + second[ 2] * first[10] + second[ 3] * first[14];
	result[ 3] = second[ 0] * first[ 3] + second[ 1] * first[ 7] + second[ 2] * first[11] + second[ 3] * first[15];
	result[ 4] = second[ 4] * first[ 0] + second[ 5] * first[ 4] + second[ 6] * first[ 8] + second[ 7] * first[12];
	result[ 5] = second[ 4] * first[ 1] + second[ 5] * first[ 5] + second[ 6] * first[ 9] + second[ 7] * first[13];
	result[ 6] = second[ 4] * first[ 2] + second[ 5] * first[ 6] + second[ 6] * first[10] + second[ 7] * first[14];
	result[ 7] = second[ 4] * first[ 3] + second[ 5] * first[ 7] + second[ 6] * first[11] + second[ 7] * first[15];
	result[ 8] = second[ 8] * first[ 0] + second[ 9] * first[ 4] + second[10] * first[ 8] + second[11] * first[12];
	result[ 9] = second[ 8] * first[ 1] + second[ 9] * first[ 5] + second[10] * first[ 9] + second[11] * first[13];
	result[10] = second[ 8] * first[ 2] + second[ 9] * first[ 6] + second[10] * first[10] + second[11] * first[14];
	result[11] = second[ 8] * first[ 3] + second[ 9] * first[ 7] + second[10] * first[11] + second[11] * first[15];
	result[12] = second[12] * first[ 0] + second[13] * first[ 4] + second[14] * first[ 8] + second[15] * first[12];
	result[13] = second[12] * first[ 1] + second[13] * first[ 5] + second[14] * first[ 9] + second[15] * first[13];
	result[14] = second[12] * first[ 2] + second[13] * first[ 6] + second[14] * first[10] + second[15] * first[14];
	result[15] = second[12] * first[ 3] + second[13] * first[ 7] + second[14] * first[11] + second[15] * first[15];
}

RoleBOOL inline inverse(RoleFLOAT matrix[16])
{
   int i, j, k, swap;
   float t;
   float temp[4][4];

   for (i = 0; i < 4; i++)
	   for (j = 0; j < 4; j++)
	   {
         temp[i][j] = matrix[(i * 4) + j];
	   }
   matrix[0] = matrix[5] = matrix[10] = matrix[15] = 1.0f;
   matrix[1] = matrix[2] = matrix[3] = matrix[4] = matrix[6] 
   = matrix[7] = matrix[8] = matrix[9] = 
   matrix[11] = matrix[12] = matrix[13] = matrix[14] = 0.0f;

	

   for (i = 0; i < 4; i++)
   {
      /*
      ** Look for largest element in column
      */
      swap = i;
      for (j = i + 1; j < 4; j++)
         if (fabs(temp[j][i]) > fabs(temp[i][i]))
            swap = j;
   
      if (swap != i)
      {
         /*
         ** Swap rows.
         */
         for (k = 0; k < 4; k++)
         {
            t = temp[i][k];
            temp[i][k] = temp[swap][k];
            temp[swap][k] = t;

            t = matrix[(i * 4) + k];
            matrix[(i * 4) + k] = matrix[(swap * 4) + k];
            matrix[(swap * 4) + k] = t;
         }
      }

      /*
      ** No non-zero pivot.  The matrix is singular, which shouldn't
      ** happen.  This means the user gave us a bad matrix.
      */
      if (temp[i][i] == 0)
         return RoleFALSE;

      t = temp[i][i];
      for (k = 0; k < 4; k++)
      {
         temp[i][k] /= t;
         matrix[(i * 4) + k] /= t;
      }
      for (j = 0; j < 4; j++)
      {
         if (j != i)
         {
            t = temp[j][i];
            for (k = 0; k < 4; k++)
            {
               temp[j][k] -= temp[i][k] * t;
               matrix[(j * 4) + k] -= matrix[(i * 4) + k] * t;
            }
         }
      }
   }
   return RoleTRUE;
}

void inline rotateCoord(RoleINT dir,RoleFLOAT angle, RoleFLOAT cx,RoleFLOAT cy, RoleFLOAT cz,
						RoleFLOAT * dstx,RoleFLOAT * dsty,RoleFLOAT * dstz)
{
	RoleFLOAT line[3] = {*dstx-cx,*dsty-cy,*dstz-cz};
	RoleFLOAT rotatedline[3] = {0};
	if (dir == RIGHT)
		angle = angle*PIE/180;
	else
		angle = -angle*PIE/180;
	RoleFLOAT matrix[3][3] = {
		{cos(angle),0,-sin(angle)},
		{0,1,0},
		{sin(angle),0,cos(angle)},
	};

	for (int i = 0; i < 3; i++)
	{
		for (int j = 0; j < 3;j++)
		{
			rotatedline[i] += matrix[i][j]*line[j];
		}
	}
	
	*dstx = rotatedline[0]+cx;
	*dsty = rotatedline[1]+cy;
	*dstz = rotatedline[2]+cz;
//	rolePrintlog("x y z: %f %f %f\n",rotatedline[0],rotatedline[1],rotatedline[2]);

}

void inline getRotateMatrixAxisOnXZ(float axis[3],float angle, float result[16])
{
	if (axis[1] < 0.0f || axis[1] > 0.0f)
	{
	    fprintf(stderr, "Axis must be on XZ plane (axis[1] value): '%f'\n",axis[1]);
	    perror ("Err ");
		return;
	}
	float r2[16] = {0};
	float r3[16] = {0};
	float temp[16] = {0};
//	r2[ 0] = r2[ 5] = axis[1];
	r2[ 0] = r2[10] = axis[2];
//	r2[10] = r2[15] = 1.0f;
	r2[ 5] = r2[15] = 1.0f;
//	r2[ 1] = axis[0];
	r2[ 2] = axis[0];
//	r2[ 4] = -r2[ 1];
	r2[ 8] = -r2[ 2];
//	getRotateMatrixXYZ(YAXIS, angle, r3);
// rotate about z axis.
	r3[10] = r3[15] = 1.0f;
	r3[ 0] = r3[5] = cos(angle);
	r3[ 1] = sin(angle);
	r3[ 4] = -r3[1]; 
	matrixMultiply4by4(r3,r2,temp);
//	r2[ 4] =  r2[ 1];
	r2[ 8] =  r2[ 2];
//	r2[ 1] = -r2[ 1];
	r2[ 2] = -r2[ 2];
	matrixMultiply4by4(r2,temp,result);
}


void inline rotateCoordOnXZ(RoleFLOAT axis[3],RoleFLOAT angle, RoleFLOAT cx,RoleFLOAT cy, RoleFLOAT cz,
						RoleFLOAT * dstx,RoleFLOAT * dsty,RoleFLOAT * dstz)
{
	RoleFLOAT line[4] = {*dstx-cx,*dsty-cy,*dstz-cz,0.0f};
	RoleFLOAT rotatedline[4] = {0};
	angle = angle*PIE/180;

	RoleFLOAT matrix[16] = {0};
	getRotateMatrixAxisOnXZ(axis,angle, matrix);
	for (int i = 0; i < 4; i++)
	{
		for (int j = 0; j < 4;j++)
		{
			rotatedline[i] += matrix[i+j*4]*line[j];
		}
	}
	
	*dstx = rotatedline[0]+cx;
	*dsty = rotatedline[1]+cy;
	*dstz = rotatedline[2]+cz;
//	rolePrintlog("x y z: %f %f %f\n",rotatedline[0],rotatedline[1],rotatedline[2]);

}



RoleCollisionTable::RoleCollisionTable(Area * a)
{
	sizeX = a->getSizeX();
	sizeY = a->getSizeY();
	table = new vector<Object *>[sizeX*sizeY];
	rolePrintlog("*********Creating collision table size : %i\n",
		a->getSizeX()*a->getSizeY());
}

RoleCollisionTable::~RoleCollisionTable()
{

}


RoleBOOL RoleCollisionTable::addObject(Object * o)
{
	addObject(o, o->getLocationX(),o->getLocationY(),o->getLocationZ());
	return RoleTRUE;
}

RoleBOOL RoleCollisionTable::addObject(Object * o, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z)
{
	RoleINT zoffset = (RoleINT) (z/Terrain::CELLSIZE);
	RoleINT xoffset = (RoleINT) (x/Terrain::CELLSIZE);
	if ((o->getWidth() > Terrain::CELLSIZE/2.0f) || (o->getLength() > Terrain::CELLSIZE/2.0f))
	{
		RoleINT i = 0;
		RoleINT j = 0;
		RoleINT startx = xoffset-(RoleINT) (o->getWidth()*2/Terrain::CELLSIZE);
		RoleINT startz = zoffset-(RoleINT) (o->getLength()*2/Terrain::CELLSIZE);
		RoleINT endx = xoffset+(RoleINT) (o->getWidth()*2/Terrain::CELLSIZE);
		RoleINT endz = zoffset+(RoleINT) (o->getLength()*2/Terrain::CELLSIZE);
		if (startx < 0)
			startx = 0;
		if (startz < 0)
			startz = 0;
		if (endx >= sizeX)
			endx = sizeX-1;
		if (endz >= sizeY)
			endz = sizeY-1;

		for (i = startx; i < endx; i++)
		{
			for(j = startz; j < endz; j++)
			{
//				rolePrintlog("Big ");
				table[j*sizeX +i].push_back(o);
			}
		}
	}
	else
	{
//		if (o->getName().compare(0,4,"tree") == 0)
//		rolePrintlog("tree ");
		table[zoffset*sizeX +xoffset].push_back(o);
	}
//	rolePrintlog("Object added\n");
	return RoleTRUE;
}

RoleBOOL RoleCollisionTable::removeObject(Object * o)
{
	vector<Object *>::iterator itor;
	vector<Object *> * curr_table;
	RoleINT zoffset = (RoleINT) (o->getLocationZ()/Terrain::CELLSIZE);
	RoleINT xoffset = (RoleINT) (o->getLocationX()/Terrain::CELLSIZE);
	RoleINT i = 0;
	if (o->getLength() > Terrain::CELLSIZE/2.0f)
	{
		RoleINT j = 0;
		RoleINT k = 0;
		RoleINT startx = xoffset-(RoleINT) (o->getWidth()/Terrain::CELLSIZE*2);
		RoleINT startz = zoffset-(RoleINT) (o->getLength()/Terrain::CELLSIZE*2);
		RoleINT endx = xoffset+(RoleINT) (o->getWidth()/Terrain::CELLSIZE*2);
		RoleINT endz = zoffset+(RoleINT) (o->getLength()/Terrain::CELLSIZE*2);
		if (startx < 0)
			startx = 0;
		if (startz < 0)
			startz = 0;
		if (endx >= sizeX)
			endx = sizeX-1;
		if (endz >= sizeY)
			endz = sizeY-1;
		for (k = startx; k < endx; k++)
		{
			for(j = startz; j < endz; j++)
			{
				curr_table = &(table[j*sizeX+k]);
				itor = curr_table->begin();
				for (i = 0;i < curr_table->size();i++)
				{
					if ((*itor)==o)
					{
						curr_table->erase(itor);
						return RoleTRUE;
					}
					itor++;
				}
			}
		}
	}
	else
	{
		curr_table = &(table[zoffset*sizeX+xoffset]);
		itor = curr_table->begin();
		for (i = 0; i < curr_table->size();i++)
		{
			if ((*itor)==o)
			{
				curr_table->erase(itor);
				return RoleTRUE;
			}
			itor++;
		}
	}
	// this should not happen usually.  Not halting program...
	rolePrintlog (" cannot remove object %s %i %i size %i ",o->getName().data(),xoffset,zoffset,curr_table->size());
	return RoleFALSE;
}


vector<Object *> *	RoleCollisionTable::getCellObjlist(RoleINT x,RoleINT z)
{
	return &(table[(RoleINT) (z*sizeX+x)]);
}

RoleBOOL RoleCollisionTable::moveObject(Object * o, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z)
{
	if (!removeObject(o))
	{
		// this should not happen usually.  Not halting program...
		rolePrintlog (" while moving %s and adding at %i %i\n",o->getName().data(),(RoleINT)(x/Terrain::CELLSIZE),(RoleINT)(z/Terrain::CELLSIZE));
	};
	if (!addObject(o,x,y,z))
	{
		// this would never happen. 
		rolePrintlog (" cannot add object %s at %f, %f, %f\n",o->getName().data(),x,y,z);
	};
	return RoleTRUE;
}


