/*****************************************************************************
**
**  terrain.h
**	
**	  Terrain management class for Role Project.
**	
**	  This class is one of the basic unit for the project with object.
**
**  Major function : drawing, loading, discarding terrain.
**  Design Idea    : a fast and efficient terrain management...
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef terrain_header
#define terrain_header

#include "types.h"

class Player;
class RoleRoam;

extern RoleBYTE currBOOL;
extern RoleBYTE inline getDrawn(RoleBYTE status);

class Terrain
{
public:
	
	/* default constructor.*/
	
	Terrain(string t_name);
	// copier
	Terrain(const Terrain & source);
	~Terrain();

	// drawing the terrain. only in the frustum.
	RoleRoam * Terrain::getRoam() const;
	void draw(Player * p);
	RoleFLOAT getHeight(RoleFLOAT xf, RoleFLOAT zf);
	RoleINT getSizeX();
	RoleINT getSizeY();
	static const RoleFLOAT CELLSIZE; // now 10.0f
	void pick_draw(Player * p,RoleUINT picked, RoleUINT startName);
	void frame_draw(Player * p);

	void updateTerrain();

private:

	friend class RoleMouse;
	RoleFLOAT * heightmap;
	RoleINT * infomap;
	RoleINT xsize;
	RoleINT ysize;
	string name;
	RoleRoam * roam;
	RoleUINT * tName;
	RoleINT numberOfTextures;
	RoleBOOL pupdate;
	void load_heightmap_from_file(); // name is the reference to the location in a file...
	void quad_tree_draw(RoleFLOAT centerx, RoleFLOAT centery
					,RoleFLOAT width, RoleFLOAT height,RoleUINT * picked,
					Player * p);
};

#endif
