/*****************************************************************************
**
**  terrain.cpp
**	
**	  The Terrain Management Class for Role Project.
**	
**	  This class is one of the basic units for the project.
**
**	see more in terrain.h
**
**	Almost done.  To do : to create infinite terrain....
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#include "util.h"
#include "image.h"
#include "roam.h"
#include "terrain.h"
#include "graphic.h"
#include "player.h"


//the resolution of terrain. 10.0f is good enough.
const RoleFLOAT Terrain::CELLSIZE = 10.0f;
extern unsigned int polycounter;

Terrain::Terrain(string t_name):
	name(t_name)
{
	load_heightmap_from_file();
	// 6000 triangles total. 50: meaningless value.
	roam = new RoleRoam(5000,50, heightmap,xsize);
	pupdate = RoleTRUE;
}

Terrain::~Terrain()
{
	rolePrintlog("Average merge : %i \n", roam->avgMerge);
	free(heightmap);
	free(infomap);
//	free(tName); I do not understand why this cause an error...
}

RoleINT Terrain::getSizeX()
{
	return xsize;
}
RoleINT Terrain::getSizeY()
{
	return ysize;
}

RoleFLOAT Terrain::getHeight(RoleFLOAT xf, RoleFLOAT zf)
{
	RoleINT x = (RoleINT) xf/CELLSIZE;
	RoleFLOAT dx = xf/CELLSIZE-x;
	RoleINT z = (RoleINT) zf/CELLSIZE;
	RoleFLOAT dz = zf/CELLSIZE-z;
	
	return 	((heightmap[z*xsize+x+1]*dx+
			  heightmap[z*xsize+x]*(1.0f-dx))*(1.0f-dz)
			+(heightmap[(z+1)*xsize+x+1]*dx+
			  heightmap[(z+1)*xsize+x]*(1.0f-dx))*dz)*CELLSIZE;

}


/************************************************************************************
load_heightmap_from_file()
  loading heightmap and infomap. bmp format. Note that the map should be upside down 
  due to the image load program 
*************************************************************************************/

void Terrain::load_heightmap_from_file()
{
	numberOfTextures = 5;
	Image * map_image = (Image *) malloc(sizeof(Image));
	Image * hmap_image = (Image *) malloc(sizeof(Image));
	RoleINT i ,j= 0;

	ImageLoad("map.bmp",map_image);
	ImageLoad("hmap.bmp",hmap_image);
	xsize = map_image->sizeX;
	ysize = map_image->sizeY;
	if ((hmap_image->sizeX != map_image->sizeX)
		|| (hmap_image->sizeY != map_image->sizeY))
	{
		rolePrintlog("Map size does not match\n");
		quit_role(1);
	}
	heightmap = (RoleFLOAT *) malloc(sizeof(GLfloat)*xsize*ysize);
	infomap = (RoleINT *) malloc(sizeof(RoleINT)*xsize*ysize);
	for ( i =0; i < xsize; i++)
	{
		for( j = 0; j < ysize; j++)
		{
			if ((map_image->data[(i+j*xsize)*4] == 0) &&
				(map_image->data[(i+j*xsize)*4+1] == 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 4;//+256*8; // grass
			}
			else if ((map_image->data[(i+j*xsize)*4] >= 127) &&
				(map_image->data[(i+j*xsize)*4+1] >= 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 3;//+256*7; // grass 
			}
			else if ((map_image->data[(i+j*xsize)*4] >= 127) &&
				(map_image->data[(i+j*xsize)*4+1] <= 127) &&
				(map_image->data[(i+j*xsize)*4+2] <= 127))
			{
				infomap[j*xsize+i] = 2;//+256*5; // road
			}
			else if ((map_image->data[(i+j*xsize)*4] >= 255) &&
				(map_image->data[(i+j*xsize)*4+1] == 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 4;//+256*6; // dirt
			}
			else 
			{
				infomap[j*xsize+i] = 1;//+256*6;
			}

			heightmap[j*xsize+i] = hmap_image->data[(i+j*xsize)*4] /32.0 +
								hmap_image->data[(i+j*xsize)*4+1] / 16.0+
								hmap_image->data[(i+j*xsize)*4+2] /256.0; 
		}
	}

	free(hmap_image->data);
	free(map_image->data);
	free(hmap_image);
	free(map_image);

	tName = (RoleUINT *) malloc (sizeof(RoleUINT)*(numberOfTextures+1));
	glGenTextures(numberOfTextures+1, tName);

//		loadTexture(tName[i], t_name); // change it later
//	loadTexture(tName[numberOfTextures], "Clouds.bmp"); // sky texture. change it later
	
// *****************************************************
//	From here, just demonstration.- quick and dirty code....
//	We need to discuss the format of file before writing actual load fuction.
	TexUnit * t = Graphic::getTexture("base.bmp",Graphic::NORMAL);
	tName[0] = t->tName;
	t = Graphic::getTexture("base2.bmp",Graphic::MIPMAP);
	tName[1] = t->tName;
/*	t = Graphic::getTexture("base2.bmp",Graphic::MIPMAP);
	tName[2] = t->tName;
	t = Graphic::getTexture("base2.bmp",Graphic::MIPMAP);
	tName[3] = t->tName;
	t = Graphic::getTexture("base2.bmp",Graphic::MIPMAP);
	tName[4] = t->tName;
*/
	t = Graphic::getTexture("Clouds.bmp",Graphic::NORMAL);
	tName[5] = t->tName;
	if (multitexture) {
		glActiveTextureARB_ptr(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, tName[0]);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glActiveTextureARB_ptr(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, tName[1]);
	}
	else
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, tName[0]);
	}
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);


//	t = Graphic::getTexture("test4.bmp",Graphic::MIPMAP);
//	tName[5] = t->tName;
//	t = Graphic::getTexture("test5.bmp",Graphic::MIPMAP);
//	tName[6] = t->tName;
//	t = Graphic::getTexture("test6.bmp",Graphic::MIPMAP);
//	tName[7] = t->tName;
//	t = Graphic::getTexture("test7.bmp",Graphic::MIPMAP);
//	tName[8] = t->tName;
}

/*
void Terrain::load_heightmap_from_file()
{
	numberOfTextures = 5;
	Image * map_image = (Image *) malloc(sizeof(Image));
	Image * hmap_image = (Image *) malloc(sizeof(Image));
	RoleINT i ,j= 0;

	ImageLoad("map.bmp",map_image);
	ImageLoad("hmap.bmp",hmap_image);
	xsize = map_image->sizeX;
	ysize = map_image->sizeY;
	if ((hmap_image->sizeX != map_image->sizeX)
		|| (hmap_image->sizeY != map_image->sizeY))
	{
		rolePrintlog("Map size does not match\n");
		quit_role(1);
	}
	heightmap = (RoleFLOAT *) malloc(sizeof(GLfloat)*xsize*ysize);
	infomap = (RoleINT *) malloc(sizeof(RoleINT)*xsize*ysize);
	for ( i =0; i < xsize; i++)
	{
		for( j = 0; j < ysize; j++)
		{
			if ((map_image->data[(i+j*xsize)*4] == 0) &&
				(map_image->data[(i+j*xsize)*4+1] == 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 3+256*8; // grass
			}
			else if ((map_image->data[(i+j*xsize)*4] == 127) &&
				(map_image->data[(i+j*xsize)*4+1] == 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 2+256*7; // grass 
			}
			else if ((map_image->data[(i+j*xsize)*4] == 127) &&
				(map_image->data[(i+j*xsize)*4+1] == 127) &&
				(map_image->data[(i+j*xsize)*4+2] == 127))
			{
				infomap[j*xsize+i] = 0+256*5; // road
			}
			else if ((map_image->data[(i+j*xsize)*4] == 255) &&
				(map_image->data[(i+j*xsize)*4+1] == 255) &&
				(map_image->data[(i+j*xsize)*4+2] == 0))
			{
				infomap[j*xsize+i] = 1+256*6; // dirt
			}
			else 
			{
				infomap[j*xsize+i] = 1+256*6;
			}

			if ((map_image->data[(i+j*xsize)*4] < 180) &&
				(map_image->data[(i+j*xsize)*4+1] < 180) &&
				(map_image->data[(i+j*xsize)*4+2] < 180))
			{
				if ((i>0) && (j > 0))
					heightmap[j*xsize+i] = heightmap[(j-1)*xsize+(i-1)];
				else
					heightmap[j*xsize+i] = 0;
//				heightmap[j*xsize+i] = hmap_image->data[(i+j*xsize)*4]/32 +
//								hmap_image->data[(i+j*xsize)*4+1] / 64.0+
//								hmap_image->data[(i+j*xsize)*4+2] / 64.0; 
			}
			else if (map_image->data[(i+j*xsize)*4] > 
				map_image->data[(i+j*xsize)*4+1]) 
			{
				heightmap[j*xsize+i] = hmap_image->data[(i+j*xsize)*4]/128+
								hmap_image->data[(i+j*xsize)*4+1]/128+
								hmap_image->data[(i+j*xsize)*4+2]/128 + 1.0f; 
//				if (heightmap[j*xsize+i] > 8)
//					heightmap[j*xsize+i]/=8;
			}
			else if (map_image->data[(i+j*xsize)*4] < 
				map_image->data[(i+j*xsize)*4+1]) 
			{
				heightmap[j*xsize+i] = hmap_image->data[(i+j*xsize)*4]/128 +
								hmap_image->data[(i+j*xsize)*4+1] /128+
								hmap_image->data[(i+j*xsize)*4+2] /128; 
			}
			else if ((map_image->data[(i+j*xsize)*4] > 158) &&
				(map_image->data[(i+j*xsize)*4+1] > 158) &&
				(map_image->data[(i+j*xsize)*4+2] > 158))
			{
				heightmap[j*xsize+i] = hmap_image->data[(i+j*xsize)*4]/128 +
								hmap_image->data[(i+j*xsize)*4+1] / 128.0+
								hmap_image->data[(i+j*xsize)*4+2] /128.0+1.0f; 
			}
			else
			{
				if ((i>0) && (j > 0))
					heightmap[j*xsize+i] = heightmap[(j-1)*xsize+(i-1)];
				else
					heightmap[j*xsize+i] = 0;
			}
		}
	}

	free(hmap_image->data);
	free(map_image->data);
	free(hmap_image);
	free(map_image);

	tName = (RoleUINT *) malloc (sizeof(RoleUINT)*(numberOfTextures+1));
	glGenTextures(numberOfTextures+1, tName);
//		loadTexture(tName[i], t_name); // change it later
//	loadTexture(tName[numberOfTextures], "Clouds.bmp"); // sky texture. change it later
	
// *****************************************************
//	From here, just demonstration.- quick and dirty code....
//	We need to discuss the format of file before writing actual load fuction.
 
	TexUnit * t = Graphic::getTexture("hmap.bmp",Graphic::NORMAL);
	tName[0] = t->tName;
	t = Graphic::getTexture("test1.bmp",Graphic::NORMAL);
	tName[1] = t->tName;
	t = Graphic::getTexture("test2.bmp",Graphic::NORMAL);
	tName[2] = t->tName;
	t = Graphic::getTexture("test3.bmp",Graphic::NORMAL);
	tName[3] = t->tName;
	t = Graphic::getTexture("Clouds.bmp",Graphic::NORMAL);
	tName[4] = t->tName;
//	t = Graphic::getTexture("test4.bmp",Graphic::MIPMAP);
//	tName[5] = t->tName;
//	t = Graphic::getTexture("test5.bmp",Graphic::MIPMAP);
//	tName[6] = t->tName;
//	t = Graphic::getTexture("test6.bmp",Graphic::MIPMAP);
//	tName[7] = t->tName;
//	t = Graphic::getTexture("test7.bmp",Graphic::MIPMAP);
//	tName[8] = t->tName;
}

*/

/* this is old pick draw. check out the next function using quad tree
void Terrain::pick_draw(Player * p,RoleUINT picked, RoleUINT startName)
{
	RoleINT startx = (RoleINT) (p->getCameraX()-p->getVisibility())/CELLSIZE;
	RoleINT startz = (RoleINT) (p->getCameraZ()-p->getVisibility())/CELLSIZE;
	RoleINT endx = (RoleINT) startx+p->getVisibility()/CELLSIZE*2; 
	RoleINT endz = (RoleINT) startz+p->getVisibility()/CELLSIZE*2;
	RoleFLOAT xcenter = 0.0f;
	RoleFLOAT ycornerA = 0.0f;
	RoleFLOAT ycornerB = 0.0f;
	RoleFLOAT ycornerC = 0.0f;
	RoleFLOAT ycornerD = 0.0f;
	RoleFLOAT zcenter = 0.0f;
	RoleFLOAT halfsize = CELLSIZE/2.0f;

 
	if (startx < 0) 
		startx = 0;
	if (startz < 0) 
		startz = 0;
	if (endx >= xsize) 
		endx = xsize-1;
	if (endz >= ysize) 
		endz = ysize-1;
	glDisable(GL_TEXTURE_2D);

	for (RoleINT i = startx; i < endx; i++)
	{
		ycornerC = CELLSIZE*heightmap[startz*xsize+i];
		ycornerD = CELLSIZE*heightmap[startz*xsize+i+1];
		for (RoleINT j = startz; j < endz; j++)
		{
			xcenter = CELLSIZE*(i+0.5);
			ycornerA = ycornerC;
			ycornerB = ycornerD;
			ycornerC = CELLSIZE*heightmap[(j+1)*xsize+i];
			ycornerD = CELLSIZE*heightmap[(j+1)*xsize+i+1];
			zcenter = CELLSIZE*(j+0.5);
			// second path object culling with Frustum. We can make it ugly to be faster
			if (cubeInFrustum(xcenter 
						,minFloat((ycornerA <  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC <  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->p_Frustum)
				|| cubeInFrustum(xcenter
						,maxFloat((ycornerA >  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC >  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->p_Frustum))
			{
				glLoadName(picked);
				picked++;
				glBegin(GL_TRIANGLE_STRIP);

				glNormal3f(0,1,0); // need to be cacluated
				glVertex3f(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
				glVertex3f(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
				glVertex3f(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
				glVertex3f(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
				glEnd();
//				polycounter+=2;
			}
		}
	}
	glEnable(GL_TEXTURE_2D);
#ifdef SELECTDEBUG
	rolePrintlog("end checking terrain with %i\n", picked);
#endif
}
*/

/* Pick_Draw

  This uses quad tree to check if the quad is in the frustum.
  without using quad tree, you have to check the square of 
  visibility value (100^2 = 10000)
  But if you are using quad tree, it takes less than 100 checks for 256*256 map.
   <=> 256*256 : depth of tree is 8 because 2^8=256.
   So, in worst case if you are in the center, the cost is
   (at top 4 hits)*(1 hit *(1hit (1hit( ...)+3fails) + 3fails )+ 3 fails) 
   = 4*(1+3*6) = 76 checks. 
   If you increase by 512*512 terrain, the worst case is
   4*(1+3*7) = 88 checks... Not a big deal.

  Note that there is no need for LOD in pick draw because
  usually the picking frustum is only 5.0f*5.0f and only 
  four terrain cells are usually drawn no matter how far it is.

  Of course you can reduce lots of multiplication in this check..
  but it does not matter much :) 
*/


void Terrain::pick_draw(Player * p,RoleUINT picked, RoleUINT startName)
{
	glColor3f(0.0f,1.0f,0.0f);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_CULL_FACE);
	quad_tree_draw((RoleFLOAT) (xsize)/2.0f,(RoleFLOAT) (ysize)/2.0f,(RoleFLOAT)xsize,(RoleFLOAT)ysize,&picked,p);
	glDisable(GL_CULL_FACE);
	glEnable(GL_TEXTURE_2D);
}

void Terrain::quad_tree_draw(RoleFLOAT centerx, RoleFLOAT centery
					,RoleFLOAT quad_width, RoleFLOAT quad_height
					,RoleUINT * picked,
					Player * p)
{
//	rolePrintlog("checked\n");
	if ((quad_width > 1) && (quad_height >1))
	{
		if (areaInFrustum(CELLSIZE*(centerx-quad_width/4)
					,CELLSIZE*(centery-quad_height/4) 
					,(quad_width >  quad_height ?  quad_width : quad_height)*CELLSIZE/4.0f
					,xsize
					,p->p_Frustum))
		{
			quad_tree_draw(centerx-quad_width/4,centery-quad_height/4,quad_width/2,quad_height/2,picked,p);
		}
		if (areaInFrustum(CELLSIZE*(centerx-quad_width/4)
					,CELLSIZE*(centery+quad_height/4) 
					,(quad_width >  quad_height ?  quad_width : quad_height)*CELLSIZE/4.0f
					,xsize
					, p->p_Frustum))
		{
			quad_tree_draw(centerx-quad_width/4,centery+quad_height/4,quad_width/2,quad_height/2,picked,p);
		}
		if (areaInFrustum(CELLSIZE*(centerx+quad_width/4)
					,CELLSIZE*(centery-quad_height/4) 
					,(quad_width >  quad_height ?  quad_width : quad_height)*CELLSIZE/4.0f
					, xsize
					, p->p_Frustum)) 
		{
			quad_tree_draw(centerx+quad_width/4,centery-quad_height/4,quad_width/2,quad_height/2,picked,p);
		}
		if (areaInFrustum(CELLSIZE*(centerx+quad_width/4)
					,CELLSIZE*(centery+quad_height/4) 
					,(quad_width >  quad_height ?  quad_width : quad_height)*CELLSIZE/2.0f
					,xsize
					, p->p_Frustum)) 
		{
 			quad_tree_draw(centerx+quad_width/4,centery+quad_height/4,quad_width/2,quad_height/2,picked,p);
		}
	}
	else
	{
		RoleFLOAT xcenter = CELLSIZE*(centerx);
		RoleFLOAT zcenter = CELLSIZE*(centery);
		RoleFLOAT ycornerA = CELLSIZE*heightmap[(RoleINT) ((centery-0.5)*((RoleFLOAT) xsize)+centerx-0.5)];
		RoleFLOAT ycornerB = CELLSIZE*heightmap[(RoleINT) ((centery-0.5)*((RoleFLOAT) xsize)+centerx+0.5)];
		RoleFLOAT ycornerC = CELLSIZE*heightmap[(RoleINT) ((centery+0.5)*((RoleFLOAT) xsize)+centerx-0.5)];
		RoleFLOAT ycornerD = CELLSIZE*heightmap[(RoleINT) ((centery+0.5)*((RoleFLOAT) xsize)+centerx+0.5)];
		RoleFLOAT halfsize = CELLSIZE/2.0f;
		if ((cubeInFrustum(xcenter 
					,minFloat((ycornerA <  ycornerB ? ycornerA : ycornerB)
							 ,(ycornerC <  ycornerD ? ycornerC : ycornerD))
					,zcenter, CELLSIZE/2.0f, p->p_Frustum)
			|| cubeInFrustum(xcenter
					,maxFloat((ycornerA >  ycornerB ? ycornerA : ycornerB)
							 ,(ycornerC >  ycornerD ? ycornerC : ycornerD))
					,zcenter, CELLSIZE/2.0f, p->p_Frustum))
			 &&(centerx+0.5 < xsize) && (centery+0.5 < xsize))
		{
//			rolePrintlog("here %f %f %f %f \n",centerx,centery,xcenter,zcenter);
			// this is not correct but approximate value.
#ifdef SCHOOL_COMPUTER_SUCKS
			glLoadName(((RoleINT) (centery-0.5))*xsize+((RoleINT) (centerx-0.5))+SCHOOL_COMPUTER_SUCKS);
#else
			glLoadName((*picked));
			(*picked)++ ;
#endif
//	
			glBegin(GL_TRIANGLE_STRIP);
			glNormal3f(0,1,0); // need to be cacluated
			glVertex3f(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
//			normal_mouse->processCoord(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
			glVertex3f(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
//			normal_mouse->processCoord(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
			glVertex3f(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
//			normal_mouse->processCoord(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
			glVertex3f(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
//			normal_mouse->processCoord(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
			glEnd();
//			polycounter+=2;
		}
	}
}


void Terrain::frame_draw(Player * p)
{
	// Purely test purpose... 
	// Use MESH to reduce the vertices && culling from camera position.

//	first path object culling.
	RoleINT i = 0;

	RoleINT width = p->getVisibility();
	RoleINT startx = (RoleINT) (p->getCameraX()-width)/CELLSIZE;
	RoleINT startz = (RoleINT) (p->getCameraZ()-width)/CELLSIZE;
	RoleINT endx = (RoleINT) startx+width/CELLSIZE*2; 
	RoleINT endz = (RoleINT) startz+width/CELLSIZE*2;
	RoleFLOAT xcenter = 0.0f;
	RoleFLOAT ycornerA = 0.0f;
	RoleFLOAT ycornerB = 0.0f;
	RoleFLOAT ycornerC = 0.0f;
	RoleFLOAT ycornerD = 0.0f;
	RoleFLOAT zcenter = 0.0f;
	RoleFLOAT halfsize = CELLSIZE/2.0f;

 
	if (startx < 0) 
		startx = 0;
	if (startz < 0) 
		startz = 0;
	if (endx >= xsize) 
		endx = xsize-1;
	if (endz >= ysize) 
		endz = ysize-1;
	glDisable(GL_TEXTURE_2D);

//	glPolygonMode(GL_FRONT,GL_LINE);
	for (i = startx; i < endx; i++)
	{
		ycornerC = CELLSIZE*heightmap[startz*xsize+i];
		ycornerD = CELLSIZE*heightmap[startz*xsize+i+1];
		for (RoleINT j = startz; j < endz; j++)
		{
			xcenter = CELLSIZE*(i+0.5);
			ycornerA = ycornerC;
			ycornerB = ycornerD;
			ycornerC = CELLSIZE*heightmap[(j+1)*xsize+i];
			ycornerD = CELLSIZE*heightmap[(j+1)*xsize+i+1];
			zcenter = CELLSIZE*(j+0.5);
			// second path object culling with Frustum. We can make it ugly to be faster
			if (cubeInFrustum(xcenter 
						,minFloat((ycornerA <  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC <  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum)
				|| cubeInFrustum(xcenter
						,maxFloat((ycornerA >  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC >  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum))
			{
				// really simple LOD.
				if ((i < ((endx+startx)/2)-width/25) || 
					(i > ((endx+startx)/2)+width/25) ||
					(j > ((endz+startz)/2)+width/25) ||
					(j < ((endz+startz)/2)-width/25))
					glBindTexture(GL_TEXTURE_2D, tName[infomap[j*xsize+i]/256]);
				else
					glBindTexture(GL_TEXTURE_2D, tName[infomap[j*xsize+i]%256]);
				glBegin(GL_TRIANGLE_STRIP);
// unit size : 10.0 positive coord 
				float SHADINGCONSTANT = 40.0f;
				if (ycornerD > 4.0f)
					SHADINGCONSTANT = 100.0f;
				glNormal3f(0,1,0); // need to be cacluated
				glColor3f(ycornerD/SHADINGCONSTANT,0.15+ycornerD/SHADINGCONSTANT,ycornerD/SHADINGCONSTANT);
				glVertex3f(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
				glColor3f(ycornerB/SHADINGCONSTANT,0.15+ycornerB/SHADINGCONSTANT,ycornerB/SHADINGCONSTANT);
				glVertex3f(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
				glColor3f(ycornerC/SHADINGCONSTANT,0.15+ycornerC/SHADINGCONSTANT,ycornerC/SHADINGCONSTANT);
				glVertex3f(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
				glColor3f(ycornerA/SHADINGCONSTANT,0.15+ycornerA/SHADINGCONSTANT,ycornerA/SHADINGCONSTANT);
				glVertex3f(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
				glEnd();
				polycounter+=2;
			}
		}
	}
	glEnable(GL_TEXTURE_2D);
	glPolygonMode(GL_FRONT,GL_FILL);
	glColor3f(1,1,1);
}

void Terrain::updateTerrain()
{
	pupdate = RoleTRUE;
}
void shadeColor(RoleFLOAT height)
{
	RoleFLOAT red,green,blue;
/*	if (height < 1)
	{ 
		green = 0.5f+height/2.0;
		red = 0;
		blue = 0;
	}
	else if (height < 10)
	{
		green = 0.2+height/10.0f;
		red = 0.35+height/10.0f;
		blue = 0;
	}
	else
	{
		green = 0.5+height/40.0f;
		red = 0.75+height/80.0f;
		blue = 0.5+height/70.0f;
	}
*/  green = 0.5f+height/40.0f;
	red = 0.35+height/5.0f;
	blue = height/128.0f;
	glColor3f(red,green,blue);
}

RoleBYTE currBOOL = FALSE;

RoleBYTE inline getDrawn(RoleBYTE status)
{
	// TRUE or FALSE depending on the previous state.
	// Kind of state machine with remembering only the previous state.
	if (currBOOL == TRUE)
		return status;
	else
	{
		if (status == TRUE)
			return FALSE;
		else
			return TRUE;
	}
}

void inline drawTriangleFan(Player * p,RoamSplitTriangleNode * node,RoleINT xsize,RoleFLOAT CELLSIZE)
{
	RoamSplitTriangleNode * node2 = node->LeftNeighbor;
	RoamSplitTriangleNode * node4 = node->RightNeighbor;
	
	node->drawn = getDrawn(TRUE);
	glBegin(GL_TRIANGLE_FAN);


	if (node2 !=NULL)
	{
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vtop.x,node->vtop.y); 
		}
		glTexCoord2f(node->vtop.x/((RoleFLOAT) xsize),node->vtop.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);

		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vright.x,node->vright.y);
		}
		glTexCoord2f(node->vright.x/((RoleFLOAT) xsize),node->vright.y/((RoleFLOAT) xsize));
		glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);

		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vleft.x,node->vleft.y); 
		}
		glTexCoord2f(node->vleft.x/((RoleFLOAT) xsize),node->vleft.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);

		// Second triangle
		node2->drawn = getDrawn(TRUE);
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node2->vleft.x,node2->vleft.y); 
		}
		glTexCoord2f(node2->vleft.x/((RoleFLOAT) xsize),node2->vleft.y/((RoleFLOAT) xsize)); 
		glVertex3f(node2->vleft.x*CELLSIZE,node2->vleft.z*CELLSIZE,node2->vleft.y*CELLSIZE);

		RoamSplitTriangleNode * node3 = node2->LeftNeighbor;
		// if node3 == null : only node, node2 exist.
		polycounter+=2;
		if (node3 !=NULL)
		{
			// Third triangle
			node3->drawn = getDrawn(TRUE);
			if (multitexture) {
				glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
					,node3->vleft.x,node3->vleft.y); 
			}
			glTexCoord2f(node3->vleft.x/((RoleFLOAT) xsize),node3->vleft.y/((RoleFLOAT) xsize)); 
			glVertex3f(node3->vleft.x*CELLSIZE,node3->vleft.z*CELLSIZE,node3->vleft.y*CELLSIZE);

			node4->drawn = getDrawn(TRUE);
			if (multitexture) {
				glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
					,node4->vleft.x,node4->vleft.y); 
			}
			glTexCoord2f(node4->vleft.x/((RoleFLOAT) xsize),node4->vleft.y/((RoleFLOAT) xsize)); 
			glVertex3f(node4->vleft.x*CELLSIZE,node4->vleft.z*CELLSIZE,node4->vleft.y*CELLSIZE);
			polycounter+=2;
		}
	}
	else if (node4 != NULL)
		// second node is null. fan the other way.
	{
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vtop.x,node->vtop.y); 
		}
		glTexCoord2f(node->vtop.x/((RoleFLOAT) xsize),node->vtop.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);

		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vleft.x,node->vleft.y); 
		}
		glTexCoord2f(node->vleft.x/((RoleFLOAT) xsize),node->vleft.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);

		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node->vright.x,node->vright.y);
		}
		glTexCoord2f(node->vright.x/((RoleFLOAT) xsize),node->vright.y/((RoleFLOAT) xsize));
		glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);

		node4->drawn = getDrawn(TRUE);
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
				,node4->vright.x,node4->vright.y); 
		}
		glTexCoord2f(node4->vright.x/((RoleFLOAT) xsize),node4->vright.y/((RoleFLOAT) xsize)); 
		glVertex3f(node4->vright.x*CELLSIZE,node4->vright.z*CELLSIZE,node4->vright.y*CELLSIZE);
		polycounter+=2;
	}
	glEnd();
}


void Terrain::draw(Player * p)
{
//	first path object culling.
	RoleINT i = 0;

/*
	RoleINT width = 100;
	RoleINT startx = (RoleINT) (p->getCameraX()-width)/CELLSIZE;
	RoleINT startz = (RoleINT) (p->getCameraZ()-width)/CELLSIZE;
	RoleINT endx = (RoleINT) startx+width/CELLSIZE*2; 
	RoleINT endz = (RoleINT) startz+width/CELLSIZE*2;
	RoleFLOAT xcenter = 0.0f;
	RoleFLOAT ycornerA = 0.0f;
	RoleFLOAT ycornerB = 0.0f;
	RoleFLOAT ycornerC = 0.0f;
	RoleFLOAT ycornerD = 0.0f;
	RoleFLOAT zcenter = 0.0f;
	RoleFLOAT halfsize = CELLSIZE/2.0f;

 
	if (startx < 0) 
		startx = 0;
	if (startz < 0) 
		startz = 0;
	if (endx >= xsize) 
		endx = xsize-1;
	if (endz >= ysize) 
		endz = ysize-1;

	for (i = startx; i < endx; i++)
	{
		ycornerC = CELLSIZE*heightmap[startz*xsize+i];
		ycornerD = CELLSIZE*heightmap[startz*xsize+i+1];
		for (RoleINT j = startz; j < endz; j++)
		{
			xcenter = CELLSIZE*(i+0.5);
			ycornerA = ycornerC;
			ycornerB = ycornerD;
			ycornerC = CELLSIZE*heightmap[(j+1)*xsize+i];
			ycornerD = CELLSIZE*heightmap[(j+1)*xsize+i+1];
			zcenter = CELLSIZE*(j+0.5);
			// second path object culling with Frustum. We can make it ugly to be faster
			if (cubeInFrustum(xcenter 
						,minFloat((ycornerA <  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC <  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum)
				|| cubeInFrustum(xcenter
						,maxFloat((ycornerA >  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC >  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum))
			{
				glBegin(GL_TRIANGLE_STRIP);
// unit size : 10.0 positive coord 
//				shadeColor(ycornerD/CELLSIZE);
				glTexCoord2f(1.0f,1.0f); glVertex3f(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
//				shadeColor(ycornerB/CELLSIZE);
				glTexCoord2f(1.0f,0.0f); glVertex3f(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
//				shadeColor(ycornerC/CELLSIZE);
				glTexCoord2f(0.0f,1.0f); glVertex3f(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
//				shadeColor(ycornerA/CELLSIZE);
				glTexCoord2f(0.0f,0.0f); glVertex3f(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
				glEnd();
				polycounter+=2;
			}
		}
	}
*/
//	glPolygonMode(GL_FRONT, GL_LINE);
	RoleINT x = 0;
	RoleINT y = 0;
	if (pupdate)
		roam->updateFrame(p);
	RoamSplitTriangleNode * node = NULL;
//	glDisable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, tName[0]);
	if (multitexture) {
		glActiveTextureARB_ptr(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, tName[1]);
	}
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	currBOOL = !currBOOL;
	for (i = 0; i < roam->splitQueue->getMySize();i++)
	{
		node = roam->splitQueue->queue[i];
//		glActiveTextureARB_ptr(GL_TEXTURE1_ARB);
//		glBindTexture(GL_TEXTURE_2D, tName[infomap[node->vtop.y*xsize + node->vtop.x]]);
		if ((node->nodeMerge !=NULL) && (node->drawn ==getDrawn(FALSE)))
		{
			drawTriangleFan(p,node,xsize,CELLSIZE);
		}
		else if ((node->drawn ==getDrawn(FALSE)) && (node->faceorientation > -0.15f))
		{
			node->drawn=getDrawn(TRUE);
			glBegin(GL_TRIANGLES);
//		x = node->vtop.x;
//		y = node->vtop.y;
/*
//		glBindTexture(GL_TEXTURE_2D, tName[infomap[y*xsize+x]%256]);
		glBegin(GL_TRIANGLES);
//		shadeColor(node->vleft.z);
		glTexCoord2f(node->vleft.x/((RoleFLOAT) xsize),node->vleft.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);
//		glTexCoord2f(0.0f,0.0f); glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);			
//		shadeColor(node->vtop.z);
		glTexCoord2f(node->vtop.x/((RoleFLOAT) xsize),node->vtop.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);
//		glTexCoord2f(0.5f,1.0f); glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);
//		shadeColor(node->vright.z);
		glTexCoord2f(node->vright.x/((RoleFLOAT) xsize),node->vright.y/((RoleFLOAT) xsize));
		glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);
//		glTexCoord2f(1.0f,0.0f); glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);
		glEnd();
*/
//		glBindTexture(GL_TEXTURE_2D, tName[infomap[y*xsize+x]%256+1]);
//		shadeColor(node->vleft.z);
//		glTexCoord2f(0.0f,0.0f); glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);			
//		shadeColor(node->vtop.z);
/*
		if ((absolute(x*CELLSIZE-p->getCameraX()) > 50.0f) && (absolute(y*CELLSIZE-p->getCameraZ())> 50.0f))
		{
			glDisable(GL_TEXTURE_2D);
//			glBindTexture(GL_TEXTURE_2D, tName[2]);
		}
		else
		{
			glEnable(GL_TEXTURE_2D);
//			glBindTexture(GL_TEXTURE_2D, tName[1]);
		}
*/
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
//			,node->vleft.x/((RoleFLOAT) xsize)*64,node->vleft.y/((RoleFLOAT) xsize)*64); 
			,node->vleft.x,node->vleft.y); 
		}
		glTexCoord2f(node->vleft.x/((RoleFLOAT) xsize),node->vleft.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vleft.x*CELLSIZE,node->vleft.z*CELLSIZE,node->vleft.y*CELLSIZE);
//		shadeColor(node->vtop.z);
//		glTexCoord2f(0.5f,1.0f); glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
//			,node->vtop.x/((RoleFLOAT) xsize)*64,node->vtop.y/((RoleFLOAT) xsize)*64); 
				,node->vtop.x,node->vtop.y); 
		}
//		glTexCoord2f(0.5f,1.0f);
		glTexCoord2f(node->vtop.x/((RoleFLOAT) xsize),node->vtop.y/((RoleFLOAT) xsize)); 
		glVertex3f(node->vtop.x*CELLSIZE,node->vtop.z*CELLSIZE,node->vtop.y*CELLSIZE);
//		shadeColor(node->vright.z);
//		glTexCoord2f(1.0f,0.0f); glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);
		if (multitexture) {
			glMultiTexCoord2fARB_ptr(GL_TEXTURE1_ARB
//			,node->vright.x/((RoleFLOAT) xsize)*64,node->vright.y/((RoleFLOAT) xsize)*64);
				,node->vright.x,node->vright.y);
		}
//		glTexCoord2f(1.0f,0.0f);
		glTexCoord2f(node->vright.x/((RoleFLOAT) xsize),node->vright.y/((RoleFLOAT) xsize));
		glVertex3f(node->vright.x*CELLSIZE,node->vright.z*CELLSIZE,node->vright.y*CELLSIZE);
		polycounter+=1;
		glEnd();
		}
	}
//	glEnable(GL_TEXTURE_2D);

//	glPolygonMode(GL_FRONT, GL_FILL);
	glColor3f(1.0f,1.0f,1.0f);
	pupdate = RoleFALSE;
	if (multitexture) {
		glActiveTextureARB_ptr(GL_TEXTURE1_ARB);
		glDisable(GL_TEXTURE_2D);
		glActiveTextureARB_ptr(GL_TEXTURE0_ARB);
	}
//	Background sky ... Sky Box.. how can we make it? 
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, tName[5]);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	RoleFLOAT skywidth = p->getVisibility()*5.6/6.0;
	RoleFLOAT skyheight = p->getVisibility()/3;
	RoleFLOAT skystartx = p->getCameraX()-skywidth;
	RoleFLOAT skystartz = p->getCameraZ()-skywidth;
	RoleFLOAT skyendx = skystartx+2*skywidth;
	RoleFLOAT skyendz = skystartz+2*skywidth;
#define OCTAFACTOR 0.5858
// octagon.
		glBegin(GL_QUADS);

	// right plane;  |
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);

	//	right back

		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
	// right front
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);

	// end of right side.
	// left side.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
	
	// left back.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);

	// left front.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);

	// back
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
	// Front
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);

		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skystartz);
		glEnd();
		
}
RoleRoam * Terrain::getRoam() const
{
	return roam;
}
/*
void Terrain::draw(Player * p)
{
	// Purely test purpose... 
	// Use MESH to reduce the vertices && culling from camera position.
	roam->updateFrame(p);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

//	first path object culling.

	RoleINT width = p->getVisibility();
	RoleINT startx = (RoleINT) (p->getCameraX()-width)/CELLSIZE;
	RoleINT startz = (RoleINT) (p->getCameraZ()-width)/CELLSIZE;
	RoleINT endx = (RoleINT) startx+width/CELLSIZE*2; 
	RoleINT endz = (RoleINT) startz+width/CELLSIZE*2;
	RoleFLOAT xcenter = 0.0f;
	RoleFLOAT ycornerA = 0.0f;
	RoleFLOAT ycornerB = 0.0f;
	RoleFLOAT ycornerC = 0.0f;
	RoleFLOAT ycornerD = 0.0f;
	RoleFLOAT zcenter = 0.0f;
	RoleFLOAT halfsize = CELLSIZE/2.0f;

 
	if (startx < 0) 
		startx = 0;
	if (startz < 0) 
		startz = 0;
	if (endx >= xsize) 
		endx = xsize-1;
	if (endz >= ysize) 
		endz = ysize-1;

	for (RoleINT i = startx; i < endx; i++)
	{
		ycornerC = CELLSIZE*heightmap[startz*xsize+i];
		ycornerD = CELLSIZE*heightmap[startz*xsize+i+1];
		for (RoleINT j = startz; j < endz; j++)
		{
			xcenter = CELLSIZE*(i+0.5);
			ycornerA = ycornerC;
			ycornerB = ycornerD;
			ycornerC = CELLSIZE*heightmap[(j+1)*xsize+i];
			ycornerD = CELLSIZE*heightmap[(j+1)*xsize+i+1];
			zcenter = CELLSIZE*(j+0.5);
			// second path object culling with Frustum. We can make it ugly to be faster
			if (cubeInFrustum(xcenter 
						,minFloat((ycornerA <  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC <  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum)
				|| cubeInFrustum(xcenter
						,maxFloat((ycornerA >  ycornerB ? ycornerA : ycornerB)
								 ,(ycornerC >  ycornerD ? ycornerC : ycornerD))
						,zcenter, halfsize, p->m_Frustum))
			{
				// really simple LOD.
				if ((i < ((endx+startx)/2)-width/25) || 
					(i > ((endx+startx)/2)+width/25) ||
					(j > ((endz+startz)/2)+width/25) ||
					(j < ((endz+startz)/2)-width/25))
					glBindTexture(GL_TEXTURE_2D, tName[infomap[j*xsize+i]/256]);
				else
					glBindTexture(GL_TEXTURE_2D, tName[infomap[j*xsize+i]%256]);
				glBegin(GL_TRIANGLE_STRIP);
// unit size : 10.0 positive coord 

				glNormal3f(0,1,0); // need to be cacluated
				glTexCoord2f(1.0f,1.0f); glVertex3f(xcenter+halfsize,ycornerD,(GLfloat) zcenter+halfsize);
				glTexCoord2f(1.0f,0.0f); glVertex3f(xcenter+halfsize,ycornerB,(GLfloat) zcenter-halfsize);
				glTexCoord2f(0.0f,1.0f); glVertex3f(xcenter-halfsize,ycornerC,(GLfloat) zcenter+halfsize);
				glTexCoord2f(0.0f,0.0f); glVertex3f(xcenter-halfsize,ycornerA,(GLfloat) zcenter-halfsize);
				glEnd();
				polycounter+=2;
			}
		}
	}
		
//	Background sky ... Sky Box.. how can we make it? 
	glBindTexture(GL_TEXTURE_2D, tName[4]);
	RoleFLOAT skywidth = p->getVisibility()*5.8/6.0;
	RoleFLOAT skyheight = p->getVisibility()/3;
	RoleFLOAT skystartx = p->getCameraX()-skywidth;
	RoleFLOAT skystartz = p->getCameraZ()-skywidth;
	RoleFLOAT skyendx = skystartx+2*skywidth;
	RoleFLOAT skyendz = skystartz+2*skywidth;
#define OCTAFACTOR 0.5858
// octagon.
		glBegin(GL_QUADS);

	// right plane;  |
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);

	//	right back

		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
	// right front
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);

	// end of right side.
	// left side.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
	
	// left back.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz+skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skystartz+skywidth*OCTAFACTOR);

	// left front.
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,skyheight,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz-skywidth*OCTAFACTOR);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);

	// back
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skyendz);
	// Front
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx-skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,skyheight,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx+skywidth*OCTAFACTOR,0.0,(GLfloat) skystartz);
		glEnd();

/* box	
	glBegin(GL_QUADS);

	// right plane;
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,100.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,100.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz);

		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,100.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,100.0,(GLfloat) skyendz);
	
	
	// back
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skyendz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skystartx,100.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skyendx,100.0,(GLfloat) skyendz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skyendz);

		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) skyendx,0.0,(GLfloat) skystartz);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) skyendx,100.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) skystartx,100.0,(GLfloat) skystartz);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) skystartx,0.0,(GLfloat) skystartz);
	glEnd();
*/
		/* flat terrain
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f); glVertex3f((GLfloat) -xsize/2,0.0,(GLfloat) -ysize/2);
		glTexCoord2f(0.0f,1.0f); glVertex3f((GLfloat) -xsize/2,0.0,(GLfloat) ysize/2);
		glTexCoord2f(1.0f,1.0f); glVertex3f((GLfloat) xsize/2,0.0,(GLfloat) ysize/2);
		glTexCoord2f(1.0f,0.0f); glVertex3f((GLfloat) xsize/2,0.0,(GLfloat) -ysize/2);
	glEnd();
		*/

//	glPopMatr